package cn.cloudself.query.plus

import cn.cloudself.query.*
import cn.cloudself.query.util.ListEx

class Plus2Table<MAIN: Any, T1: Any, T2: Any> constructor(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    private val clazz: Class<MAIN>,
) {
    inner class On constructor(
        private val joinType: JoinType,
        private val newClazz: Class<*>,
        private val alias: String? = null,
    ) {
        private fun <T1: Any, T2: Any> on(left: Column, right: Column): Plus2Table<MAIN, T1, T2>.Joined {
            val table = newClazz.toTable()
            val joinerOns = listOf(FromJoinerOn(left, right))
            queryStructure.from.joins.add(FromJoiner(joinType, table, joinerOns, alias))
            return Plus2Table<MAIN, T1, T2>(queryStructure, payload, clazz).Joined()
        }
        fun on(column: Col1<T1>, newTableColumn: Col2<T2>) = on<T1, T2>(column.toField(), newTableColumn.toField())
        fun on(newTableColumn: Col2<T2>, column: Col1<T1>) = on<T1, T2>(newTableColumn.toField(), column.toField())

        fun <T2: Any> on(table1column: Col1<T1>, table2alias: String, table2column: Col2<T2>) = on<T1, Alias>(table1column.toField(), table2column.toField(table2alias))
        fun <T2: Any> on(table2alias: String, table2column: Col2<T2>, table1column: Col<T1>) = on<T1, Alias>(table1column.toField(), table2column.toField(table2alias))

        fun <T1: Any> on(table1alias: String, table1column: Col1<T1>, table2column: Col2<T2>) = on<T1, T2>(table1column.toField(table1alias), table2column.toField())
        fun <T1: Any> on(table2column: Col2<T2>, table1alias: String, table1column: Col1<T1>) = on<T1, T2>(table1column.toField(table1alias), table2column.toField())
        fun <TA: Any, TN: Any> on(table1alias: String, table1column: Col1<TA>, table2alias: String, table2column: Col2<TN>) = on<Alias, Alias>(table1column.toField(table1alias), table2column.toField(table2alias))
    }

    abstract inner class Field<RUN_RES>: QueryField<MAIN, RUN_RES, WhereField<RUN_RES>, OrderByField<RUN_RES>, ColumnLimiterField<RUN_RES>, ColumnsLimiterField<RUN_RES>>() {
        override fun createWhereField(qs: QueryStructure, payload: QueryPayload) = WhereField<RUN_RES>(qs, payload, clazz)
        override fun createOrderByField(qs: QueryStructure, payload: QueryPayload) = OrderByField<RUN_RES>(qs, payload, clazz)
        override fun createColumnLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnLimiterField<RUN_RES>(qs, payload, clazz)
        override fun createColumnsLimitField(qs: QueryStructure, payload: QueryPayload) = ColumnsLimiterField<RUN_RES>(qs, payload, clazz)
    }

    inner class WhereField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.WHERE_FIELD

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeKeywords()
        fun column(column: Col1<T1>) = column.toField().makeKeywords()
        fun column(column: Col2<T2>) = column.toField().makeKeywords()
        private fun Column.makeKeywords() = QueryKeywords(this, queryStructure, payload, ::createWhereField)
    }

    inner class OrderByField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.ORDER_BY_FIELD

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeKeywords()
        fun column(column: Col1<T1>) = column.toField().makeKeywords()
        fun column(column: Col2<T2>) = column.toField().makeKeywords()
        private fun Column.makeKeywords() = QueryOrderByKeywords(this, queryStructure, payload, ::createOrderByField)
    }

    inner class ColumnLimiterField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.OTHER_FIELD

        fun <TA: Any, V: Any> column(alias: String, column: Get<TA, V>) = column.toField(alias).queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get1<T1, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        fun <V: Any> column(column: Get2<T2, V>) = column.toField().queryWithColumnLimiter(column.getReturnType())
        private fun <V: Any> Column.queryWithColumnLimiter(clazz: Class<V>) = ListEx(getColumn(this, clazz))
    }

    inner class ColumnsLimiterField<RUN_RES>(
        override val queryStructure: QueryStructure,
        override val payload: QueryPayload,
        override val clazz: Class<MAIN>
    ): Field<RUN_RES>() {
        override val fieldType = QueryFieldType.OTHER_FIELD

        fun <A: Any> column(alias: String, column: Col<A>) = column.toField(alias).makeColumnsLimiter()
        fun column(column: Col1<T1>) = column.toField().makeColumnsLimiter()
        fun column(column: Col2<T2>) = column.toField().makeColumnsLimiter()
        private fun Column.makeColumnsLimiter() = this.also {
            queryStructure.fields = queryStructure.fields + this
        }
    }

    inner class Joined {
        fun <NEW: Any> leftJoin (entity: Class<NEW>) = Plus3Table<MAIN, T1, T2, NEW>(queryStructure, payload, clazz).On(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: Class<NEW>) = Plus3Table<MAIN, T1, T2, NEW>(queryStructure, payload, clazz).On(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: Class<NEW>) = Plus3Table<MAIN, T1, T2, NEW>(queryStructure, payload, clazz).On(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: Class<NEW>, alias: String) = Plus3Table<MAIN, T1, T2, Alias>(queryStructure, payload, clazz).On(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: Class<NEW>, alias: String) = Plus3Table<MAIN, T1, T2, Alias>(queryStructure, payload, clazz).On(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: Class<NEW>, alias: String) = Plus3Table<MAIN, T1, T2, Alias>(queryStructure, payload, clazz).On(JoinType.INNER_JOIN, entity, alias)

        fun where() = WhereField<List<MAIN>>(queryStructure, payload, clazz)
    }
}
