package cn.cloudself.query.plus

import cn.cloudself.query.*
import cn.cloudself.query.util.to_snake_case
import javax.persistence.Table
import kotlin.RuntimeException
import kotlin.reflect.KClass
import kotlin.reflect.KProperty
import kotlin.reflect.KProperty1
import kotlin.reflect.jvm.javaField

typealias Getter   <T> = KProperty1<T, Any?>
typealias GetterNew<T> = KProperty1<T, Any?>
typealias Getter1  <T> = KProperty1<T, Any?>
typealias Getter2  <T> = KProperty1<T, Any?>
typealias Getter3  <T> = KProperty1<T, Any?>
typealias Getter4  <T> = KProperty1<T, Any?>
typealias Getter5  <T> = KProperty1<T, Any?>
typealias Getter6  <T> = KProperty1<T, Any?>

class KQueryProPlus<T: Any> constructor(
    private val queryStructure: QueryStructure,
    private val payload: QueryPayload,
    alias: String? = null
) {

    init {
        if (alias != null) {
            queryStructure.from.alias = alias
        }
    }

    fun <NEW: Any> leftJoin (entity: KClass<NEW>) = On2Table<NEW>(JoinType.LEFT_JOIN, entity)
    fun <NEW: Any> rightJoin(entity: KClass<NEW>) = On2Table<NEW>(JoinType.RIGHT_JOIN, entity)
    fun <NEW: Any> innerJoin(entity: KClass<NEW>) = On2Table<NEW>(JoinType.INNER_JOIN, entity)
    fun <NEW: Any> leftJoin (entity: KClass<NEW>, alias: String) = On2Table<Alias>(JoinType.LEFT_JOIN, entity, alias)
    fun <NEW: Any> rightJoin(entity: KClass<NEW>, alias: String) = On2Table<Alias>(JoinType.RIGHT_JOIN, entity, alias)
    fun <NEW: Any> innerJoin(entity: KClass<NEW>, alias: String) = On2Table<Alias>(JoinType.INNER_JOIN, entity, alias)

    inner class On2Table<NEW: Any> constructor(
        private val type: JoinType,
        private val clazz: KClass<*>,
        private val alias: String? = null,
    ) {
        private fun <T1: Any, T2: Any> on(left: Field, right: Field): Plus2TableJoined<T1, T2> {
            val table = alias ?: toTable(clazz)
            val joinerOns = listOf(FromJoinerOn(left, right))
            queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
            return Plus2TableJoined(queryStructure, payload)
        }
        @JvmName("on2")
        fun on(column: Getter1<T>, newTableColumn: GetterNew<NEW>) = on<T, NEW>(column.toColumn(), newTableColumn.toColumn())
        @JvmName("on2_")
        fun on(newTableColumn: GetterNew<NEW>, column: Getter1<T>) = on<T, NEW>(newTableColumn.toColumn(), column.toColumn())

        @JvmName("on3")
        fun <T2: Any> on(table1column: Getter<T>, table2alias: String, table2column: Getter2<T2>) = on<T, Alias>(table1column.toColumn(), table2column.toColumn(table2alias))
        @JvmName("on3")
        fun <T2: Any> on(table2alias: String, table2column: Getter2<T2>, table1column: Getter<T>) = on<T, Alias>(table1column.toColumn(), table2column.toColumn(table2alias))

        fun <T1: Any> on(table1alias: String, table1column: Getter1<T1>, table2column: Getter<NEW>) = on<T, NEW>(table1column.toColumn(table1alias), table2column.toColumn())
        fun <T1: Any> on(table2column: Getter<NEW>, table1alias: String, table1column: Getter1<T1>) = on<T, NEW>(table1column.toColumn(table1alias), table2column.toColumn())
        fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on<T, Alias>(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
    }

    class Plus2TableJoined<T1: Any, T2: Any> constructor(
        private val queryStructure: QueryStructure,
        private val payload: QueryPayload,
    ) {
        fun <NEW: Any> leftJoin (entity: KClass<NEW>) = On3Table<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>) = On3Table<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>) = On3Table<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: KClass<NEW>, alias: String) = On3Table<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>, alias: String) = On3Table<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>, alias: String) = On3Table<Alias>(JoinType.INNER_JOIN, entity, alias)

        inner class On3Table<NEW: Any> constructor(
            private val type: JoinType,
            private val clazz: KClass<*>,
            private val alias: String? = null,
        ) {
            private fun <T1: Any, T2: Any, T3: Any> on(left: Field, right: Field): Plus3TableJoined<T1, T2, T3> {
                val table = alias ?: toTable(clazz)
                val joinerOns = listOf(FromJoinerOn(left, right))
                queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
                return Plus3TableJoined(queryStructure, payload)
            }
            @JvmName("on1")
            fun on(t1: Getter1<T1>, new: GetterNew<NEW>) = on<T1, T2, NEW>(t1.toColumn(), new.toColumn())
            @JvmName("on2")
            fun on(t2: Getter2<T2>, new: GetterNew<NEW>) = on<T1, T2, NEW>(t2.toColumn(), new.toColumn())
            @JvmName("on3")
            fun on(new: GetterNew<NEW>, t1: Getter1<T1>) = on(t1, new)
            @JvmName("on4")
            fun on(new: GetterNew<NEW>, t2: Getter2<T2>) = on(t2, new)

            @JvmName("on5")
            fun <TN: Any> on(table1column: Getter1<T1>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on6")
            fun <TN: Any> on(table2column: Getter2<T2>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on7")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table1column: Getter1<T1>) = on<T1, T2, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on8")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table2column: Getter2<T2>) = on<T1, T2, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            fun <TA: Any> on(table1alias: String, table1column: Getter1<TA>, table3column: Getter<NEW>) = on<T1, T2, NEW>(table1column.toColumn(table1alias), table3column.toColumn())
            fun <TA: Any> on(table3column: Getter<NEW>, table1alias: String, table1column: Getter1<TA>) = on<T1, T2, NEW>(table1column.toColumn(table1alias), table3column.toColumn())
            fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on<T1, T2, Alias>(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
        }
    }

    class Plus3TableJoined<T1: Any, T2: Any, T3: Any> constructor(
        private val queryStructure: QueryStructure,
        private val payload: QueryPayload,
    ) {
        fun <NEW: Any> leftJoin (entity: KClass<NEW>) = On4Table<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>) = On4Table<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>) = On4Table<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: KClass<NEW>, alias: String) = On4Table<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>, alias: String) = On4Table<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>, alias: String) = On4Table<Alias>(JoinType.INNER_JOIN, entity, alias)

        inner class On4Table<NEW: Any> constructor(
            private val type: JoinType,
            private val clazz: KClass<*>,
            private val alias: String? = null,
        ) {
            private fun <T1: Any, T2: Any, T3: Any, T4: Any> on(left: Field, right: Field): Plus4TableJoined<T1, T2, T3, T4> {
                val table = alias ?: toTable(clazz)
                val joinerOns = listOf(FromJoinerOn(left, right))
                queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
                return Plus4TableJoined(queryStructure, payload)
            }

            @JvmName("on21")
            fun on(t1: Getter1<T1>, new: GetterNew<NEW>) = on<T1, T2, T3, NEW>(t1.toColumn(), new.toColumn())
            @JvmName("on22")
            fun on(t2: Getter2<T2>, new: GetterNew<NEW>) = on<T1, T2, T3, NEW>(t2.toColumn(), new.toColumn())
            @JvmName("on23")
            fun on(t3: Getter3<T3>, new: GetterNew<NEW>) = on<T1, T2, T3, NEW>(t3.toColumn(), new.toColumn())
            @JvmName("on25")
            fun on(new: GetterNew<NEW>, t1: Getter1<T1>) = on(t1, new)
            @JvmName("on26")
            fun on(new: GetterNew<NEW>, t2: Getter2<T2>) = on(t2, new)
            @JvmName("on27")
            fun on(new: GetterNew<NEW>, t3: Getter3<T3>) = on(t3, new)

            @JvmName("on31")
            fun <TN: Any> on(table1column: Getter1<T1>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on32")
            fun <TN: Any> on(table2column: Getter2<T2>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on33")
            fun <TN: Any> on(table3column: Getter3<T3>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, Alias>(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            @JvmName("on34")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table1column: Getter1<T1>) = on<T1, T2, T3, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on35")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table2column: Getter2<T2>) = on<T1, T2, T3, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on36")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table3column: Getter3<T3>) = on<T1, T2, T3, Alias>(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            fun <TA: Any> on(table1alias: String, table1column: Getter1<TA>, table3column: Getter<NEW>) = on<T1, T2, T3, NEW>(table1column.toColumn(table1alias), table3column.toColumn())
            fun <TA: Any> on(table3column: Getter<NEW>, table1alias: String, table1column: Getter1<TA>) = on<T1, T2, T3, NEW>(table1column.toColumn(table1alias), table3column.toColumn())
            fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on<T1, T2, T3, Alias>(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
        }
    }

    class Plus4TableJoined<T1: Any, T2: Any, T3: Any, T4: Any> constructor(
        private val queryStructure: QueryStructure,
        private val payload: QueryPayload,
    ) {
        fun <NEW: Any> leftJoin (entity: KClass<NEW>) = On5Table<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>) = On5Table<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>) = On5Table<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.INNER_JOIN, entity, alias)

        inner class On5Table<NEW: Any> constructor(
            private val type: JoinType,
            private val clazz: KClass<*>,
            private val alias: String? = null,
        ) {
            private fun <T1: Any, T2: Any, T3: Any, T4: Any, T5: Any> on(left: Field, right: Field): Plus5TableJoined<T1, T2, T3, T4, T5> {
                val table = alias ?: toTable(clazz)
                val joinerOns = listOf(FromJoinerOn(left, right))
                queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
                return Plus5TableJoined(queryStructure, payload)
            }

            @JvmName("on21")
            fun on(t1: Getter1<T1>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, NEW>(t1.toColumn(), new.toColumn())
            @JvmName("on22")
            fun on(t2: Getter2<T2>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, NEW>(t2.toColumn(), new.toColumn())
            @JvmName("on23")
            fun on(t3: Getter3<T3>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, NEW>(t3.toColumn(), new.toColumn())
            @JvmName("on24")
            fun on(t4: Getter4<T4>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, NEW>(t4.toColumn(), new.toColumn())
            @JvmName("on25")
            fun on(new: GetterNew<NEW>, t1: Getter1<T1>) = on(t1, new)
            @JvmName("on27")
            fun on(new: GetterNew<NEW>, t2: Getter2<T2>) = on(t2, new)
            @JvmName("on28")
            fun on(new: GetterNew<NEW>, t3: Getter3<T3>) = on(t3, new)
            @JvmName("on29")
            fun on(new: GetterNew<NEW>, t4: Getter4<T4>) = on(t4, new)

            @JvmName("on31")
            fun <TN: Any> on(table1column: Getter1<T1>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on32")
            fun <TN: Any> on(table2column: Getter2<T2>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on33")
            fun <TN: Any> on(table3column: Getter3<T3>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, Alias>(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on34")
            fun <TN: Any> on(table4column: Getter4<T4>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, Alias>(table4column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            @JvmName("on35")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table1column: Getter1<T1>) = on<T1, T2, T3, T4, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on36")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table2column: Getter2<T2>) = on<T1, T2, T3, T4, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on37")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table3column: Getter3<T3>) = on<T1, T2, T3, T4, Alias>(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on38")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table4column: Getter4<T4>) = on<T1, T2, T3, T4, Alias>(table4column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            fun <TA: Any> on(table1alias: String, table1column: Getter1<TA>, table3column: Getter<NEW>) = on<T1, T2, T3, T4, NEW>(table1column.toColumn(table1alias), table3column.toColumn())
            fun <TA: Any> on(table3column: Getter<NEW>, table1alias: String, table1column: Getter1<TA>) = on<T1, T2, T3, T4, NEW>(table1column.toColumn(table1alias), table3column.toColumn())
            fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on<T1, T2, T3, T4, Alias>(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
        }
    }

    class Plus5TableJoined<T1: Any, T2: Any, T3: Any, T4: Any, T5: Any> constructor(
        private val queryStructure: QueryStructure,
        private val payload: QueryPayload,
    ) {
        fun <NEW: Any> leftJoin (entity: KClass<NEW>) = On5Table<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>) = On5Table<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>) = On5Table<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.INNER_JOIN, entity, alias)

        inner class On5Table<NEW: Any> constructor(
            private val type: JoinType,
            private val clazz: KClass<*>,
            private val alias: String? = null,
        ) {
            private fun <T1: Any, T2: Any, T3: Any, T4: Any, T5: Any, T6: Any> on(left: Field, right: Field): Plus6TableJoined<T1, T2, T3, T4, T5, T6> {
                val table = alias ?: toTable(clazz)
                val joinerOns = listOf(FromJoinerOn(left, right))
                queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
                return Plus6TableJoined(queryStructure, payload)
            }

            @JvmName("on21")
            fun on(t1: Getter1<T1>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, T5, NEW>(t1.toColumn(), new.toColumn())
            @JvmName("on22")
            fun on(t2: Getter2<T2>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, T5, NEW>(t2.toColumn(), new.toColumn())
            @JvmName("on23")
            fun on(t3: Getter3<T3>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, T5, NEW>(t3.toColumn(), new.toColumn())
            @JvmName("on24")
            fun on(t4: Getter4<T4>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, T5, NEW>(t4.toColumn(), new.toColumn())
            @JvmName("on25")
            fun on(t5: Getter5<T5>, new: GetterNew<NEW>) = on<T1, T2, T3, T4, T5, NEW>(t5.toColumn(), new.toColumn())
            @JvmName("on26")
            fun on(new: GetterNew<NEW>, t1: Getter1<T1>) = on(t1, new)
            @JvmName("on27")
            fun on(new: GetterNew<NEW>, t2: Getter2<T2>) = on(t2, new)
            @JvmName("on28")
            fun on(new: GetterNew<NEW>, t3: Getter3<T3>) = on(t3, new)
            @JvmName("on29")
            fun on(new: GetterNew<NEW>, t4: Getter4<T4>) = on(t4, new)

            @JvmName("on31")
            fun <TN: Any> on(table1column: Getter1<T1>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, T5, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on32")
            fun <TN: Any> on(table2column: Getter2<T2>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, T5, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on33")
            fun <TN: Any> on(table3column: Getter3<T3>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, T5, Alias>(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on34")
            fun <TN: Any> on(table4column: Getter4<T4>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, T5, Alias>(table4column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on35")
            fun <TN: Any> on(table5column: Getter5<T5>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on<T1, T2, T3, T4, T5, Alias>(table5column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            @JvmName("on36")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table1column: Getter1<T1>) = on<T1, T2, T3, T4, T5, Alias>(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on37")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table2column: Getter2<T2>) = on<T1, T2, T3, T4, T5, Alias>(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on38")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table3column: Getter3<T3>) = on<T1, T2, T3, T4, T5, Alias>(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on39")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table4column: Getter4<T4>) = on<T1, T2, T3, T4, T5, Alias>(table4column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on310")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table5column: Getter5<T5>) = on<T1, T2, T3, T4, T5, Alias>(table5column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            fun <TA: Any> on(table1alias: String, table1column: Getter1<TA>, tableNewColumn: Getter<NEW>) = on<T1, T2, T3, T4, T5, NEW>(table1column.toColumn(table1alias), tableNewColumn.toColumn())
            fun <TA: Any> on(tableNewColumn: Getter<NEW>, table1alias: String, table1column: Getter1<TA>) = on<T1, T2, T3, T4, T5, NEW>(table1column.toColumn(table1alias), tableNewColumn.toColumn())
            fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on<T1, T2, T3, T4, T5, Alias>(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
        }
    }

    class Plus6TableJoined<T1: Any, T2: Any, T3: Any, T4: Any, T5: Any, T6: Any> constructor(
        private val queryStructure: QueryStructure,
        private val payload: QueryPayload,
    ) {
        fun <NEW: Any> leftJoin (entity: KClass<NEW>) = On5Table<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>) = On5Table<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>) = On5Table<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW: Any> leftJoin (entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW: Any> rightJoin(entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW: Any> innerJoin(entity: KClass<NEW>, alias: String) = On5Table<Alias>(JoinType.INNER_JOIN, entity, alias)

        inner class On5Table<NEW: Any> constructor(
            private val type: JoinType,
            private val clazz: KClass<*>,
            private val alias: String? = null,
        ) {
            private fun on(left: Field, right: Field): PlusManyTableJoined {
                val table = alias ?: toTable(clazz)
                val joinerOns = listOf(FromJoinerOn(left, right))
                queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
                return PlusManyTableJoined(queryStructure, payload)
            }

            @JvmName("on21")
            fun on(t1: Getter1<T1>, new: GetterNew<NEW>) = on(t1.toColumn(), new.toColumn())
            @JvmName("on22")
            fun on(t2: Getter2<T2>, new: GetterNew<NEW>) = on(t2.toColumn(), new.toColumn())
            @JvmName("on23")
            fun on(t3: Getter3<T3>, new: GetterNew<NEW>) = on(t3.toColumn(), new.toColumn())
            @JvmName("on24")
            fun on(t4: Getter4<T4>, new: GetterNew<NEW>) = on(t4.toColumn(), new.toColumn())
            @JvmName("on25")
            fun on(t5: Getter5<T5>, new: GetterNew<NEW>) = on(t5.toColumn(), new.toColumn())
            @JvmName("on26")
            fun on(t6: Getter6<T6>, new: GetterNew<NEW>) = on(t6.toColumn(), new.toColumn())
            @JvmName("on27")
            fun on(new: GetterNew<NEW>, t1: Getter1<T1>) = on(t1, new)
            @JvmName("on28")
            fun on(new: GetterNew<NEW>, t2: Getter2<T2>) = on(t2, new)
            @JvmName("on29")
            fun on(new: GetterNew<NEW>, t3: Getter3<T3>) = on(t3, new)
            @JvmName("on210")
            fun on(new: GetterNew<NEW>, t4: Getter4<T4>) = on(t4, new)

            @JvmName("on31")
            fun <TN: Any> on(table1column: Getter1<T1>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on32")
            fun <TN: Any> on(table2column: Getter2<T2>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on33")
            fun <TN: Any> on(table3column: Getter3<T3>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on34")
            fun <TN: Any> on(table4column: Getter4<T4>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on(table4column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on35")
            fun <TN: Any> on(table5column: Getter5<T5>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on(table5column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on36")
            fun <TN: Any> on(table6column: Getter6<T6>, tableNewAlias: String, tableNewColumn: Getter<TN>) = on(table6column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            @JvmName("on37")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table1column: Getter1<T1>) = on(table1column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on38")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table2column: Getter2<T2>) = on(table2column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on39")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table3column: Getter3<T3>) = on(table3column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on310")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table4column: Getter4<T4>) = on(table4column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on311")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table5column: Getter5<T5>) = on(table5column.toColumn(), tableNewColumn.toColumn(tableNewAlias))
            @JvmName("on312")
            fun <TN: Any> on(tableNewAlias: String, tableNewColumn: Getter<TN>, table6column: Getter6<T6>) = on(table6column.toColumn(), tableNewColumn.toColumn(tableNewAlias))

            fun <TA: Any> on(table1alias: String, table1column: Getter1<TA>, tableNewColumn: Getter<NEW>) = on(table1column.toColumn(table1alias), tableNewColumn.toColumn())
            fun <TA: Any> on(tableNewColumn: Getter<NEW>, table1alias: String, table1column: Getter1<TA>) = on(table1column.toColumn(table1alias), tableNewColumn.toColumn())
            fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
        }
    }

    class PlusManyTableJoined constructor(
        private val queryStructure: QueryStructure,
        private val payload: QueryPayload,
    ) {
        fun <NEW : Any> leftJoin (entity: KClass<NEW>) = OnManyTable<NEW>(JoinType.LEFT_JOIN, entity)
        fun <NEW : Any> rightJoin(entity: KClass<NEW>) = OnManyTable<NEW>(JoinType.RIGHT_JOIN, entity)
        fun <NEW : Any> innerJoin(entity: KClass<NEW>) = OnManyTable<NEW>(JoinType.INNER_JOIN, entity)
        fun <NEW : Any> leftJoin (entity: KClass<NEW>, alias: String) = OnManyTable<Alias>(JoinType.LEFT_JOIN, entity, alias)
        fun <NEW : Any> rightJoin(entity: KClass<NEW>, alias: String) = OnManyTable<Alias>(JoinType.RIGHT_JOIN, entity, alias)
        fun <NEW : Any> innerJoin(entity: KClass<NEW>, alias: String) = OnManyTable<Alias>(JoinType.INNER_JOIN, entity, alias)

        inner class OnManyTable<NEW: Any> constructor(
            private val type: JoinType,
            private val clazz: KClass<*>,
            private val alias: String? = null,
        ) {
            private fun on(
                left: Field,
                right: Field
            ): PlusManyTableJoined {
                val table = alias ?: toTable(clazz)
                val joinerOns = listOf(FromJoinerOn(left, right))
                queryStructure.from.joins.add(FromJoiner(type, table, joinerOns, alias))
                return PlusManyTableJoined(queryStructure, payload)
            }

            fun <T: Any> on(t: Getter<T>, tn: Getter2<NEW>) = on(t.toColumn(), tn.toColumn())
            fun <TA: Any> on(table1alias: String, table1column: Getter1<TA>, tableNewColumn: Getter<NEW>) = on(table1column.toColumn(table1alias), tableNewColumn.toColumn())
            fun <TA: Any> on(tableNewColumn: Getter<NEW>, table1alias: String, table1column: Getter1<TA>) = on(table1column.toColumn(table1alias), tableNewColumn.toColumn())
            fun <TA: Any, TN: Any> on(table1alias: String, table1column: Getter1<TA>, table2alias: String, table2column: Getter2<TN>) = on(table1column.toColumn(table1alias), table2column.toColumn(table2alias))
        }
    }

    companion object {
        private fun toTable(clazz: KClass<*>) = toTable(clazz.java)
        private fun toTable(clazz: Class<*>) =
            try {
                clazz.getAnnotation(Table::class.java)
            } catch (e: Exception) {
                null
            }?.name ?: to_snake_case(clazz.simpleName)

        private fun KProperty<*>.toColumn(alias: String? = null): Field {
            val table = alias ?: toTable(this.javaField?.declaringClass ?: throw RuntimeException("to column failed."))
            val field = this.name
            return Field(table, field)
        }
    }
}
