package cn.cloudself.query.plus

import cn.cloudself.query.Field
import cn.cloudself.query.util.to_snake_case
import java.io.Serializable
import java.lang.invoke.SerializedLambda
import javax.persistence.Table

fun interface Col   <T: Any>: Serializable { fun getter(table: T): Any? }
fun interface ColNew<T: Any>: Serializable { fun getter(table: T): Any? }
fun interface Col1  <T: Any>: Serializable { fun getter(table: T): Any? }
fun interface Col2  <T: Any>: Serializable { fun getter(table: T): Any? }
fun interface Col3  <T: Any>: Serializable { fun getter(table: T): Any? }
fun interface Col4  <T: Any>: Serializable { fun getter(table: T): Any? }
fun interface Col5  <T: Any>: Serializable { fun getter(table: T): Any? }
fun interface Col6  <T: Any>: Serializable { fun getter(table: T): Any? }

fun interface Get  <T: Any, V: Any>: Serializable { fun getter(table: T): V? }
fun interface Get1  <T: Any, V: Any>: Get<T, V>
fun interface Get2  <T: Any, V: Any>: Get<T, V>
fun interface Get3  <T: Any, V: Any>: Get<T, V>
fun interface Get4  <T: Any, V: Any>: Get<T, V>
fun interface Get5  <T: Any, V: Any>: Get<T, V>
fun interface Get6  <T: Any, V: Any>: Get<T, V>

internal fun Class<*>.toTable() =
    try {
        this.getAnnotation(Table::class.java)
    } catch (e: Exception) {
        null
    }?.name ?: to_snake_case(this.simpleName)

internal fun Serializable.toField(alias: String? = null): Field {
    val clazz = this.javaClass
    val writeReplace = clazz.getDeclaredMethod("writeReplace")
    writeReplace.isAccessible = true
    val sl = writeReplace.invoke(this) as SerializedLambda
    val className = sl.implClass.replace('/', '.')
    val table = alias ?: Class.forName(className).toTable()
    val field = sl.implMethodName
    @Suppress("LocalVariableName")
    val snake_case_field = to_snake_case(
        if (field.startsWith("get"))
            field.substring(3)
        else
            field
    )
    return Field(table, snake_case_field)
}

val jniFieldDescMap = mapOf<String, Class<*>>(
    "Z" to Boolean::class.java,
    "B" to Byte::class.java,
    "C" to Char::class.java,
    "S" to Short::class.java,
    "I" to Int::class.java,
    "J" to Long::class.java,
    "F" to Float::class.java,
    "D" to Double::class.java,
    "V" to Void::class.java,
)

internal fun <T: Any, V: Any> Get<T, V>.getReturnType(): Class<V> {
    val clazz = this.javaClass
    val writeReplace = clazz.getDeclaredMethod("writeReplace")
    writeReplace.isAccessible = true
    // SerializedLambda structure, see JavaNative Interface FieldDescriptors
    val sl = writeReplace.invoke(this) as SerializedLambda
    val returnType = sl.implMethodSignature.substring(sl.implMethodSignature.lastIndexOf(')') + 1)

    @Suppress("UNCHECKED_CAST")
    return if (returnType.startsWith('L')) {
        val clazzStr = returnType.substring(1, returnType.length - 1).replace('/', '.')
        Class.forName(clazzStr) as Class<V>
    } else {
        jniFieldDescMap[returnType] as Class<V>
    }
}
