package cn.cloudself.query

/**
 * 描述查询，更新，插入，删除的一个可序列化的结构
 */
data class QueryStructure(
    var action: QueryStructureAction = QueryStructureAction.SELECT,
    var update: Update? = null,
    var insert: Insert? = null,
    var distinct: Boolean = false,
    var fields: List<Field> = listOf(),
    var from: QueryStructureFrom = QueryStructureFrom(),
    var where: List<WhereClause> = listOf(),
    var orderBy: List<OrderByClause> = listOf(),
    var limit: Pair<Int, Int>? = null,
)

data class Insert(
    var data: Collection<Any>? = null,
)

data class Update(
    var data: Any? = null,
    var override: Boolean = false,
    var id: String? = null,
)

data class OrderByClause(
    var field: Field,
    var operator: String,
)

data class Field(
    var table: String? = null,
    var column: String,
    var commands: FieldCommands? = null,
)

enum class FieldCommands {
    UPPER_CASE,
}

enum class WhereClauseCommands {
    UPPER_CASE,
}

data class WhereClause(
    var field: Field? = null,
    var operator: String,
    var value: Any? = null, // null arrayOr<string boolean integer long date> List<WhereClause>
    var commands: WhereClauseCommands? = null,
    var sql: String? = null,
)

enum class QueryStructureAction {
    SELECT,
    UPDATE,
    DELETE,
    INSERT,
}

data class FromJoinerOn(
    var left: Field,
    var right: Field,
)

enum class JoinType {
    LEFT_JOIN,
    RIGHT_JOIN,
    INNER_JOIN,
}

data class FromJoiner(
    var type: JoinType,
    var table: String,
    var on: List<FromJoinerOn>,
    var alias: String?,
)

data class QueryStructureFrom(
    var main: String = "?",
    var alias: String? = null,
    var joins: MutableList<FromJoiner> = mutableListOf(),
) {
    constructor(main: String) : this(main, null, mutableListOf())
}
