package cn.cloudself.demo.java.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * 
 */
@Entity
@Table(name = "user")
public class ZzUser implements Serializable {
    private static final long serialVersionUID = 1L;

    /**  */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    private Long id;

    /**  */
    @Column(name = "name")
    private String name;

    /**  */
    @Column(name = "age")
    private Integer age;

    /**  */
    @Column(name = "sex")
    private String sex;

    /**  */
    @Column(name = "deleted")
    private Boolean deleted;

    public Long getId() {
        return id;
    }

    public ZzUser setId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public ZzUser setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getAge() {
        return age;
    }

    public ZzUser setAge(Integer age) {
        this.age = age;
        return this;
    }

    public String getSex() {
        return sex;
    }

    public ZzUser setSex(String sex) {
        this.sex = sex;
        return this;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public ZzUser setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ZzUser zzUser = (ZzUser) o;
        return Objects.equals(id, zzUser.id) && Objects.equals(name, zzUser.name) && Objects.equals(age, zzUser.age) && Objects.equals(sex, zzUser.sex) && Objects.equals(deleted, zzUser.deleted);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, age, sex, deleted);
    }

    @Override
    public String toString() {
        return "ZzUser{" +
                ", id=" + id +
                ", name='" + name + '\'' +
                ", age=" + age +
                ", sex='" + sex + '\'' +
                ", deleted=" + deleted +
                '}';
    }

}
