package cn.cloudscope.bean;

import lombok.Data;

/**
 * 上传文件后返回的结果
 * Created by wupanhua on 2018/9/11.
 */
@Data
public class YKUPResult {

    /**
     * 文件路径
     */
    private String phyPath;
    /**
     * 文件名称
     */
    private String fileName;
    /**
     * 缩略图地址，如果当前文件为图片则有缩略图
     */
    private String thumbnail;

    public YKUPResult() {
    }

    public YKUPResult(String phyPath, String fileName) {
        this.phyPath = phyPath;
        this.fileName = fileName;
    }

    /**
     * 创建一个返回对象
     * @param pp
     * @param fn
     * @return
     */
    public static YKUPResult createResult(String pp, String fn) {
        return new YKUPResult(pp, fn);
    }

    /**
     * 创建图片返回类型
     * @param phyPath
     * @param thumbnail
     * @return
     */
    public static YKUPResult createThumbnailResult(String phyPath, String thumbnail) {
        YKUPResult ykupResult = new YKUPResult();
        ykupResult.setPhyPath(phyPath);
        ykupResult.setThumbnail(thumbnail);

        return ykupResult;
    }

    public static final YKUPResult EMPTY = new YKUPResult();
}
