/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.utils;

import cn.cloudscope.oss.utils.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoUtil {
    private static final Logger log = LoggerFactory.getLogger(VideoUtil.class);
    public static final Double STAND_FRAME_RATE = 56.0;
    private static final String[] SIGNATURE_VIDEO = new String[]{"0000001466747970", "0000002066747970", "0000001866747970", "52494646", "6D6F6F76", "66726565", "6D646174", "77696465", "706E6F74", "736B6970", "2E524D46", "3026B2758E66CF11"};

    public static boolean isVideo(InputStream fileStream) {
        String fileSignature = FileUtil.getFileSignature(fileStream);
        if (null != fileSignature) {
            for (String signature : SIGNATURE_VIDEO) {
                if (!fileSignature.startsWith(signature)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVideo(File file) {
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            boolean bl = VideoUtil.isVideo(fis);
            return bl;
        }
        catch (IOException e) {
            log.error("\u65e0\u6cd5\u786e\u5b9a\u4f20\u5165\u6587\u4ef6\u662f\u5426\u4e3a\u89c6\u9891\u6587\u4ef6\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static InputStream captureFrame(File video, int frameNo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static BufferedImage frameToBufferedImage(Frame frame) {
        Java2DFrameConverter converter = new Java2DFrameConverter();
        return converter.getBufferedImage(frame);
    }

    /*
     * Exception decompiling
     */
    public static VideoInfo grabberVideoFramer(File video, File imagesFolder, boolean deleteVideo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isVideo(String key) {
        return key.endsWith("mp4") || key.endsWith("mov");
    }

    public static class VideoInfo {
        private Integer height;
        private Integer width;
        private Double frameRateOrigin;
        private Double duration;
        private String rotate;

        public Integer getHeight() {
            return this.height;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Double getFrameRateOrigin() {
            return this.frameRateOrigin;
        }

        public Double getDuration() {
            return this.duration;
        }

        public String getRotate() {
            return this.rotate;
        }

        public void setHeight(Integer height) {
            this.height = height;
        }

        public void setWidth(Integer width) {
            this.width = width;
        }

        public void setFrameRateOrigin(Double frameRateOrigin) {
            this.frameRateOrigin = frameRateOrigin;
        }

        public void setDuration(Double duration) {
            this.duration = duration;
        }

        public void setRotate(String rotate) {
            this.rotate = rotate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VideoInfo)) {
                return false;
            }
            VideoInfo other = (VideoInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$height = this.getHeight();
            Integer other$height = other.getHeight();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Integer this$width = this.getWidth();
            Integer other$width = other.getWidth();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Double this$frameRateOrigin = this.getFrameRateOrigin();
            Double other$frameRateOrigin = other.getFrameRateOrigin();
            if (this$frameRateOrigin == null ? other$frameRateOrigin != null : !((Object)this$frameRateOrigin).equals(other$frameRateOrigin)) {
                return false;
            }
            Double this$duration = this.getDuration();
            Double other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
                return false;
            }
            String this$rotate = this.getRotate();
            String other$rotate = other.getRotate();
            return !(this$rotate == null ? other$rotate != null : !this$rotate.equals(other$rotate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VideoInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $height = this.getHeight();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Integer $width = this.getWidth();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Double $frameRateOrigin = this.getFrameRateOrigin();
            result = result * 59 + ($frameRateOrigin == null ? 43 : ((Object)$frameRateOrigin).hashCode());
            Double $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
            String $rotate = this.getRotate();
            result = result * 59 + ($rotate == null ? 43 : $rotate.hashCode());
            return result;
        }

        public String toString() {
            return "VideoUtil.VideoInfo(height=" + this.getHeight() + ", width=" + this.getWidth() + ", frameRateOrigin=" + this.getFrameRateOrigin() + ", duration=" + this.getDuration() + ", rotate=" + this.getRotate() + ")";
        }
    }
}

