/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.utils;

import cn.cloudscope.oss.utils.ImageType;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    private static final String SUFFIX_THUMBNAIL = "-thumbnail";

    private ImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Double getRotate(BufferedInputStream inputStream) {
        try {
            inputStream.mark(inputStream.available() + 1);
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)inputStream);
            Iterable directories = metadata.getDirectories();
            for (Directory directory : directories) {
                if (!"Exif IFD0".equals(directory.getName())) continue;
                Collection tags = directory.getTags();
                for (Tag tag : tags) {
                    if (tag.getTagType() != 20) continue;
                    Double d = ImageUtil.getRealRotate(tag.getDescription());
                    return d;
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u56fe\u7247\u89d2\u5ea6\u5f02\u5e38: {}", (Object)e.getMessage());
        }
        finally {
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {}
        }
        return 0.0;
    }

    private static Double getRealRotate(String description) {
        if (description.startsWith("Right side")) {
            return 90.0;
        }
        if (description.startsWith("Bottom, right side")) {
            return 180.0;
        }
        if (description.startsWith("Right side, bottom")) {
            return -90.0;
        }
        return 0.0;
    }

    public static boolean isImage(String suffix) {
        ImageType[] imageTypes;
        if (suffix.contains(".")) {
            suffix = StringUtils.substringAfterLast((String)suffix, (String)".");
        }
        for (ImageType imageType : imageTypes = ImageType.values()) {
            if (!imageType.getExt().equalsIgnoreCase(suffix)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream buildThumbnail(File file, String suffix) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            BufferedImage bufferedImage = ImageIO.read(file);
            Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).scale((double)Math.min(1.0f, 20480.0f / (float)file.length())).outputFormat(suffix).toOutputStream((OutputStream)os);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7f29\u7565\u56fe\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String appendSuffixHyphenThumbnail(String fileName) {
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            return fileName.substring(0, indexOfDot) + SUFFIX_THUMBNAIL + fileName.substring(indexOfDot);
        }
        return fileName + SUFFIX_THUMBNAIL;
    }

    public static boolean isImage(File file) {
        String detectedType;
        Tika tika = new Tika();
        try {
            detectedType = tika.detect(file);
        }
        catch (Exception e) {
            log.error("detect image error: {}", (Object)e.getMessage());
            return false;
        }
        MediaType mediaType = MediaType.parse((String)detectedType);
        return mediaType.getType().equals("image");
    }

    public static BufferedImage rotateImage(BufferedImage originImage, int degree) {
        int width = originImage.getWidth(null);
        int height = originImage.getHeight(null);
        int type = originImage.getColorModel().getTransparency();
        Rectangle rectangle = ImageUtil.calcRotatedSize(new Rectangle(new Dimension(width, height)), degree);
        BufferedImage bi = new BufferedImage(rectangle.width, rectangle.height, type);
        Graphics2D g2 = bi.createGraphics();
        g2.translate((double)(rectangle.width - width) / 2.0, (double)(rectangle.height - height) / 2.0);
        g2.rotate(Math.toRadians(degree), (double)width / 2.0, (double)height / 2.0);
        g2.drawImage((Image)originImage, 0, 0, null);
        g2.dispose();
        return bi;
    }

    public static Rectangle calcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angelAlpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angelDeltaWidth = Math.atan((double)src.height / (double)src.width);
        double angelDeltaHeight = Math.atan((double)src.width / (double)src.height);
        int lenDeltaWidth = (int)(len * Math.cos(Math.PI - angelAlpha - angelDeltaWidth));
        int lenDeltaHeight = (int)(len * Math.cos(Math.PI - angelAlpha - angelDeltaHeight));
        int desWidth = src.width + lenDeltaWidth * 2;
        int desHeight = src.height + lenDeltaHeight * 2;
        return new Rectangle(new Dimension(desWidth, desHeight));
    }
}

