/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileSignature(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = FileUtil.getFileSignature(fis);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSignature(InputStream stream) {
        try {
            byte[] src = new byte[28];
            int size = stream.read(src, 0, 28);
            if (size <= 0) {
                String string = null;
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (byte b : src) {
                int v = b & 0xFF;
                String hv = Integer.toHexString(v).toUpperCase();
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u7b7e\u540d\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return null;
    }

    public static String getFileSignature(String filePath) {
        return FileUtil.getFileSignature(new File(filePath));
    }

    public static String getFileSuffix(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return StringUtils.substringAfterLast((String)fileName, (String)".");
        }
        return "";
    }

    public static String getFileName(String ossPath) {
        if (StringUtils.isNotBlank((CharSequence)ossPath)) {
            return StringUtils.substringAfterLast((String)ossPath, (String)"/");
        }
        return ossPath;
    }
}

