/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.utils;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    private static final ThreadLocal<Map<String, SimpleDateFormat>> safeFormat = new ThreadLocal();
    private static final ThreadLocal<Calendar> safeCalendar = ThreadLocal.withInitial(Calendar::getInstance);

    private static SimpleDateFormat getformatTools(DateStyle dateStyle) {
        try {
            SimpleDateFormat sdf;
            String style = dateStyle.getStyle();
            HashMap tool = safeFormat.get();
            if (tool == null) {
                tool = Maps.newHashMap();
            }
            if ((sdf = (SimpleDateFormat)tool.get(style)) == null) {
                sdf = new SimpleDateFormat(style, Locale.getDefault());
                tool.put(style, sdf);
                safeFormat.set(tool);
            }
            SimpleDateFormat simpleDateFormat = sdf;
            return simpleDateFormat;
        }
        catch (Exception ex) {
            log.error("getformatTools exception", (Throwable)ex);
            throw ex;
        }
        finally {
            safeFormat.remove();
        }
    }

    public static String format(Date date, DateStyle dateStyle) {
        if (Objects.isNull(date)) {
            return null;
        }
        return DateUtil.getformatTools(dateStyle).format(date);
    }

    public static Date parse(String dateStr, DateStyle dateStyle) {
        if (StringUtils.isEmpty((Object)dateStr)) {
            return null;
        }
        Date date = null;
        try {
            date = DateUtil.getformatTools(dateStyle).parse(dateStr);
        }
        catch (ParseException e) {
            log.error("\u683c\u5f0f\u5316\u65e5\u671f\u5931\u8d25 error", (Throwable)e);
        }
        return date;
    }

    public static int getYear(Date date) {
        try {
            if (null != date) {
                safeCalendar.get().setTime(date);
                int n = safeCalendar.get().get(1);
                return n;
            }
        }
        finally {
            safeCalendar.remove();
        }
        return 0;
    }

    public static int getMounth(Date date) {
        try {
            if (null != date) {
                safeCalendar.get().setTime(date);
                int n = safeCalendar.get().get(2) + 1;
                return n;
            }
        }
        finally {
            safeCalendar.remove();
        }
        return 0;
    }

    public static Integer getDayDuration(Date start, Date end) {
        Integer duration = null;
        if (null != end && null != start) {
            duration = 1;
            Calendar startCalendar = DateUtils.toCalendar((Date)start);
            Calendar endCalendar = DateUtils.toCalendar((Date)end);
            while (startCalendar.compareTo(endCalendar) < 0) {
                int weekDay = startCalendar.get(7);
                if (weekDay < 7 && weekDay > 1) {
                    Integer n = duration;
                    Integer n2 = duration = Integer.valueOf(duration + 1);
                }
                startCalendar.add(6, 1);
            }
        }
        return duration;
    }

    public static String getDatePoor(Date starDate, Date endDate) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long diff = endDate.getTime() - starDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206\u949f" + sec + "\u79d2";
    }

    public static enum DateStyle {
        ALL("yyyy-MM-dd HH:mm:ss"),
        YEAE_MONTH_DAY("yyyy-MM-dd"),
        HH_DOT_MM_DOT_SS("HH:mm:ss"),
        NEW_DATE("_yyyy_MM_dd_HH_mm_ss"),
        YYYYMMDDHH_mm("yyyyMMddHH_mm"),
        YEARMONTHDAY("yyyyMMdd"),
        YYYYMMDDHHMM("yyyyMMddHHmm");

        private String style;

        private DateStyle() {
        }

        private DateStyle(String style) {
            this.style = style;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

