/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.service.impl;

import cn.cloudscope.oss.config.properties.CosProperties;
import cn.cloudscope.oss.service.StorageWorker;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentCosWorker
implements StorageWorker {
    private static final Logger log = LoggerFactory.getLogger(TencentCosWorker.class);
    private final CosProperties cosProperties;
    private final COSClient cosClient;

    public TencentCosWorker(CosProperties cosProperties) {
        this.cosProperties = cosProperties;
        BasicCOSCredentials cred = new BasicCOSCredentials(cosProperties.getAccessKey(), cosProperties.getSecretKey());
        ClientConfig clientConfig = new ClientConfig(new Region(cosProperties.getRegion()));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        this.cosClient = new COSClient((COSCredentials)cred, clientConfig);
    }

    @Override
    public String doUpload(InputStream stream, String bucket, String path, String originName) {
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)stream.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            if (StringUtils.isNotBlank((CharSequence)originName)) {
                metadata.setContentDisposition("attachment;filename=" + originName);
            }
            PutObjectResult result = this.cosClient.putObject(bucket, path, stream, metadata);
            if (log.isDebugEnabled()) {
                log.debug("cos upload success: {}", (Object)result);
            }
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream download(String key) {
        COSObject object = this.cosClient.getObject(this.cosProperties.getBucketName(), key);
        return object.getObjectContent();
    }

    @Override
    public String copyObject(String source, String target, boolean isPublic) {
        String bucket = this.getBucket(isPublic);
        CopyObjectResult result = this.cosClient.copyObject(bucket, source, bucket, target);
        if (null != result && result.getETag() != null) {
            return target;
        }
        return null;
    }

    @Override
    public boolean deleteFile(String path) {
        this.cosClient.deleteObject(this.cosProperties.getBucketName(), path);
        return !this.cosClient.doesObjectExist(this.cosProperties.getBucketName(), path);
    }

    @Override
    public String crateFileExpireUrl(String path, int expire) {
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(this.cosProperties.getBucketName(), path);
        long time = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(expire);
        generatePresignedUrlRequest.setExpiration(new Date(time));
        URL url = this.cosClient.generatePresignedUrl(generatePresignedUrlRequest);
        return url.toString();
    }

    @Override
    public String getEndpoint() {
        return this.cosProperties.getEndPoint();
    }

    @Override
    public String getBucket(boolean isPublic) {
        return isPublic ? this.cosProperties.getBucketPublic() : this.cosProperties.getBucketName();
    }
}

