/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.service.impl;

import cn.cloudscope.oss.bean.DocumentReturnCodeEnum;
import cn.cloudscope.oss.bean.PreSingUploadParam;
import cn.cloudscope.oss.config.properties.MinioProperties;
import cn.cloudscope.oss.service.StorageWorker;
import cn.cloudscope.oss.utils.FileUtil;
import cn.cloudscope.oss.utils.UUIDUtil;
import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.UploadObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.MinioException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioWorker
implements StorageWorker {
    private static final Logger log = LoggerFactory.getLogger(MinioWorker.class);
    private final MinioClient minioClient;
    private final MinioProperties minioProperties;

    public MinioWorker(MinioProperties minioProperties) {
        this.minioProperties = minioProperties;
        this.minioClient = MinioClient.builder().credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).endpoint(minioProperties.getEndPoint()).build();
        try {
            BucketExistsArgs bucketExistsArgs;
            if (minioProperties.getEndPoint().startsWith("https")) {
                this.minioClient.ignoreCertCheck();
            }
            if (!this.minioClient.bucketExists(bucketExistsArgs = (BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(minioProperties.getBucketName())).build())) {
                MakeBucketArgs bucketArgs = (MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(minioProperties.getBucketName())).build();
                this.minioClient.makeBucket(bucketArgs);
            }
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316minio worker\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public String doUpload(InputStream stream, String bucket, String path, String originName) {
        if (null != stream) {
            try {
                log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6(by stream)\uff0cstream size: {}", (Object)stream.available());
                PutObjectArgs args = (PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucket)).contentType(TYPE_CACHE.getOrDefault(FileUtil.getFileSuffix(originName), ContentType.APPLICATION_OCTET_STREAM.getMimeType())).object(path)).stream(stream, -1L, 0x3200000L).build();
                ObjectWriteResponse response = this.minioClient.putObject(args);
                log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210(by stream): {}", (Object)response.object());
                String string = response.object();
                return string;
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                throw new RuntimeException(DocumentReturnCodeEnum.SERVER_UNAVAILABLE.getMsg());
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return null;
    }

    @Override
    public String doUpload(File file, String bucket, String path) {
        try {
            log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\uff0cstream size(by file): {}", (Object)Files.size(file.toPath()));
            UploadObjectArgs args = (UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(this.minioProperties.getBucketName())).contentType(ContentType.APPLICATION_OCTET_STREAM.getMimeType()).object(path)).filename(file.getAbsolutePath()).build();
            ObjectWriteResponse response = this.minioClient.uploadObject(args);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210(by file): {}", (Object)response.object());
            return response.object();
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(DocumentReturnCodeEnum.SERVER_UNAVAILABLE.getMsg());
        }
    }

    @Override
    public InputStream download(String key) {
        GetObjectArgs getArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.minioProperties.getBucketName())).object(key)).build();
        try {
            return this.minioClient.getObject(getArgs);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e.getMessage() + key);
        }
    }

    @Override
    public String copyObject(String originPath, String target, boolean isPublic) {
        try {
            String bucket = this.getBucket(isPublic);
            ObjectWriteResponse response = this.minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().bucket(bucket)).object(target)).source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(bucket)).object(originPath)).build()).build());
            if (null != response) {
                return response.object();
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(DocumentReturnCodeEnum.BACKUP_FAILED.getMsg());
        }
    }

    private String doGenerateUrl(String key, int expiresIn) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException, ServerException {
        GetPresignedObjectUrlArgs originArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.minioProperties.getBucketName())).method(Method.GET).expiry(expiresIn).object(key)).build();
        return this.minioClient.getPresignedObjectUrl(originArgs);
    }

    @Override
    public String getEndpoint() {
        return this.minioProperties.getEndPoint();
    }

    @Override
    public String getBucket(boolean isPublic) {
        return isPublic ? this.minioProperties.getBucketPublic() : this.minioProperties.getBucketName();
    }

    @Override
    public String crateFileExpireUrl(String path, int expire) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        GetPresignedObjectUrlArgs originArgs = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.minioProperties.getBucketName())).method(Method.GET).expiry(expire).object(path)).build();
        try {
            return this.minioClient.getPresignedObjectUrl(originArgs);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("error info ", e);
            return null;
        }
    }

    @Override
    public Map<String, String> preSignUpload(PreSingUploadParam param) {
        String bucket = this.getBucket(param.isPublic());
        String suffix = FileUtil.getFileSuffix(param.getFilename());
        String path = this.generatePath(UUIDUtil.buildUuid() + "." + suffix);
        if (null != param.getExpiresIn()) {
            param.setExpiresIn(Duration.ofMinutes(10L));
        }
        ZonedDateTime expirationDate = ZonedDateTime.now().plusMinutes(param.getExpiresIn().toMinutes());
        PostPolicy policy = new PostPolicy(bucket, expirationDate);
        policy.addEqualsCondition("key", path);
        if (null == param.getSize()) {
            param.setSize(0x3200000);
        }
        policy.addContentLengthRangeCondition(5120, param.getSize().intValue());
        if (null != param.getContentType()) {
            policy.addStartsWithCondition("Content-Type", param.getContentType());
        }
        policy.addEqualsCondition("success_action_status", String.valueOf(200));
        try {
            Map map = this.minioClient.getPresignedPostFormData(policy);
            map.put("key", path);
            return map;
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("get upload error: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean deleteFile(String path) {
        try {
            if (StringUtils.isNotBlank((CharSequence)path)) {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.minioProperties.getBucketName())).object(path)).build());
            }
        }
        catch (MinioException | IOException | GeneralSecurityException e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25", e);
            throw new RuntimeException(DocumentReturnCodeEnum.SERVER_UNAVAILABLE.getMsg());
        }
        return true;
    }
}

