/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.service.impl;

import cn.cloudscope.oss.bean.DocumentReturnCodeEnum;
import cn.cloudscope.oss.config.properties.OssProperties;
import cn.cloudscope.oss.service.StorageWorker;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunWorker
implements StorageWorker {
    private static final Logger log = LoggerFactory.getLogger(AliyunWorker.class);
    private final OSSClient ossClient;
    private final OssProperties ossProperties;

    public AliyunWorker(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
        this.ossClient = (OSSClient)new OSSClientBuilder().build(ossProperties.getEndPoint(), ossProperties.getAccessKey(), ossProperties.getSecretKey());
    }

    @Override
    public String doUpload(InputStream stream, String bucket, String path, String originName) {
        try {
            if (null == stream) {
                String string = null;
                return string;
            }
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength((long)stream.available());
            metadata.setCacheControl("no-cache");
            metadata.setHeader("Pragma", (Object)"no-cache");
            metadata.setContentEncoding("utf-8");
            if (StringUtils.isNotBlank((CharSequence)originName)) {
                metadata.setHeader("filename", (Object)URLEncoder.encode(originName, "utf-8"));
            }
            PutObjectResult putObjectResult = this.ossClient.putObject(this.ossProperties.getBucketName(), path, stream, metadata);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210: {}", (Object)putObjectResult.getETag());
            String string = path;
            return string;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(DocumentReturnCodeEnum.SERVER_UNAVAILABLE.getMsg());
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Override
    public String copyObject(String originPath, String target, boolean isPublic) {
        try {
            String bucket = this.getBucket(isPublic);
            CopyObjectResult copyObjectResult = this.ossClient.copyObject(new CopyObjectRequest(bucket, originPath, bucket, target));
            if (null != copyObjectResult && copyObjectResult.getResponse().isSuccessful()) {
                return target;
            }
        }
        catch (Exception e) {
            log.error("OSS\u590d\u5236\u5931\u8d25" + e, (Throwable)e);
            throw new RuntimeException(DocumentReturnCodeEnum.BACKUP_FAILED.getMsg());
        }
        return null;
    }

    @Override
    public String getEndpoint() {
        return this.ossProperties.getEndPoint();
    }

    @Override
    public boolean deleteFile(String path) {
        this.ossClient.deleteObject(this.ossProperties.getBucketName(), path);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream download(String key) {
        if (!this.ossClient.doesObjectExist(this.ossProperties.getBucketName(), key)) {
            throw new RuntimeException(String.valueOf(404));
        }
        OSSObject ossObject = this.ossClient.getObject(this.ossProperties.getBucketName(), key);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (ossObject != null) {
            try (InputStream inputStream = ossObject.getObjectContent();){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                }
            }
            catch (IOException e) {
                log.error("error info ", (Throwable)e);
            }
            finally {
                try {
                    ossObject.close();
                }
                catch (IOException e) {
                    log.error("error info ", (Throwable)e);
                }
            }
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        return null;
    }

    @Override
    public String crateFileExpireUrl(String path, int expire) {
        Date expiresIn = new Date(System.currentTimeMillis() + (long)expire * 1000L);
        String url = this.ossClient.generatePresignedUrl(this.ossProperties.getBucketName(), path, expiresIn).toString();
        return url;
    }

    @Override
    public String getBucket(boolean isPublic) {
        return isPublic ? this.ossProperties.getBucketPublic() : this.ossProperties.getBucketName();
    }
}

