/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudscope.oss.service;

import cn.cloudscope.oss.bean.DocumentReturnCodeEnum;
import cn.cloudscope.oss.bean.DocumentUrlResult;
import cn.cloudscope.oss.bean.PreSingUploadParam;
import cn.cloudscope.oss.bean.UploadResult;
import cn.cloudscope.oss.utils.FileUtil;
import cn.cloudscope.oss.utils.ImageUtil;
import cn.cloudscope.oss.utils.PathUtil;
import cn.cloudscope.oss.utils.UUIDUtil;
import cn.cloudscope.oss.utils.VideoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface StorageWorker {
    public static final Logger log = LoggerFactory.getLogger(StorageWorker.class);
    public static final String SUFFIX_THUMBNAIL = "-thumbnail";
    public static final String SUFFIX_BACKUP = "-backup";
    public static final Map<String, String> TYPE_CACHE = new HashMap<String, String>(){
        {
            this.put("png", ContentType.IMAGE_PNG.getMimeType());
            this.put("jpg", ContentType.IMAGE_JPEG.getMimeType());
            this.put("jpeg", ContentType.IMAGE_JPEG.getMimeType());
            this.put("gif", ContentType.IMAGE_GIF.getMimeType());
            this.put("mp4", "video/mp4");
            this.put("markdown", "text/markdown");
            this.put("pdf", "application/pdf");
            this.put("doc", "application/msword");
            this.put("docx", "application/msword");
        }
    };

    default public UploadResult upload(InputStream inputStream, String fileName, String folder, boolean thumbnail) {
        return this.upload(inputStream, fileName, folder, thumbnail, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public UploadResult upload(InputStream inputStream, String fileName, String folder, boolean thumbnail, boolean isPublic) {
        String path = this.generatePath(folder, UUIDUtil.buildUuid() + "." + FileUtil.getFileSuffix(fileName));
        String bucketName = this.getBucket(isPublic);
        UploadResult result = new UploadResult();
        File temp = new File(UUIDUtil.buildUuid() + "." + FileUtil.getFileSuffix(fileName));
        try (OutputStream outputStream = Files.newOutputStream(temp.toPath(), new OpenOption[0]);){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            String thumbnailUrl = this.buildThumbnail(path, bucketName, temp);
            result.setThumbnail(thumbnailUrl);
            String url = this.doUpload(Files.newInputStream(temp.toPath(), new OpenOption[0]), bucketName, path, fileName);
            result.setFileName(fileName);
            result.setPhyPath(url);
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u751f\u6210\u7f29\u7565\u56fe: {}", (Object)e.getMessage());
        }
        finally {
            FileUtils.deleteQuietly((File)temp);
        }
        return result;
    }

    default public UploadResult upload(InputStream inputStream, String fileName, String folder) {
        return this.upload(inputStream, fileName, folder, false);
    }

    default public UploadResult upload(InputStream inputStream, String fileName) {
        return this.upload(inputStream, fileName, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public UploadResult upload(File file, String folder) {
        UploadResult result = new UploadResult();
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            UploadResult uploadResult = this.upload(fis, file.getName(), folder, true);
            return uploadResult;
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return result;
        }
    }

    public String doUpload(InputStream var1, String var2, String var3, String var4);

    default public String doUpload(File file, String bucket, String path) throws IOException {
        return this.doUpload(Files.newInputStream(file.toPath(), new OpenOption[0]), bucket, path, null);
    }

    default public String generatePath(String folder, String fileName) {
        if (StringUtils.isNotBlank((CharSequence)folder)) {
            return folder.endsWith("/") ? folder + fileName : folder + "/" + fileName;
        }
        return this.generatePath(fileName);
    }

    default public UploadResult upload(String filePath, String folder) {
        return this.upload(new File(filePath), folder);
    }

    default public UploadResult upload(File file) {
        return this.upload(file, null);
    }

    default public String buildThumbnail(String path, String bucket, File file) {
        try {
            String suffix = FileUtil.getFileSuffix(file.getName());
            if (ImageUtil.isImage(file)) {
                InputStream thumbnailStream = ImageUtil.buildThumbnail(file, suffix);
                if (null != thumbnailStream && thumbnailStream.available() > 0) {
                    return this.doUpload(thumbnailStream, bucket, ImageUtil.appendSuffixHyphenThumbnail(path), null);
                }
            } else if (VideoUtil.isVideo(file)) {
                InputStream frameStream = VideoUtil.captureFrame(file, 20);
                String framePath = StringUtils.substringBeforeLast((String)path, (String)".") + ".jpg";
                if (null != frameStream) {
                    this.doUpload(frameStream, bucket, framePath, null);
                    return framePath;
                }
            }
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u751f\u6210\u7f29\u7565\u56fe: {}", (Object)e.getMessage());
        }
        return null;
    }

    default public String appendSuffix(String fileName, String suffix) {
        String newFileName;
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot != -1) {
            newFileName = fileName.substring(0, indexOfDot);
            newFileName = newFileName + suffix;
            newFileName = newFileName + fileName.substring(indexOfDot);
        } else {
            newFileName = fileName + suffix;
        }
        return newFileName;
    }

    public InputStream download(String var1);

    default public void download(String key, OutputStream response) {
        try (InputStream download = this.download(key);){
            IOUtils.copyLarge((InputStream)download, (OutputStream)response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    default public String backupFile(String originPath, boolean deleteOrigin, boolean isPublic) {
        try {
            String backup = this.appendSuffix(originPath, SUFFIX_BACKUP);
            String target = this.copyObject(originPath, backup, isPublic);
            if (null != target && deleteOrigin) {
                this.deleteFile(originPath);
            }
            return target;
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(DocumentReturnCodeEnum.BACKUP_FAILED.getMsg());
        }
    }

    public String copyObject(String var1, String var2, boolean var3);

    public boolean deleteFile(String var1);

    default public List<UploadResult> uploadMultipleFile(List<File> files) {
        return files.stream().map(this::upload).collect(Collectors.toList());
    }

    public String crateFileExpireUrl(String var1, int var2);

    default public Map<String, String> preSignUpload(PreSingUploadParam param) {
        return null;
    }

    default public UploadResult createImgExpireUrl(String path, int expire) {
        String originalImgUrl = this.crateFileExpireUrl(path, expire);
        String hyphenThumbnail = this.appendSuffix(path, SUFFIX_THUMBNAIL);
        String thumbnailUrl = this.crateFileExpireUrl(hyphenThumbnail, expire);
        return UploadResult.createThumbnailResult(originalImgUrl, thumbnailUrl);
    }

    default public DocumentUrlResult createImgExpireUrl(String path, int expire, String bucket) {
        if (StringUtils.isNotBlank((CharSequence)bucket) && this.getPublicBucket().equals(bucket)) {
            return this.getPublicDocumentUrl(path);
        }
        String originalImgUrl = this.crateFileExpireUrl(path, expire);
        String hyphenThumbnail = this.appendSuffix(path, SUFFIX_THUMBNAIL);
        String thumbnailUrl = this.crateFileExpireUrl(hyphenThumbnail, expire);
        return DocumentUrlResult.builder().url(originalImgUrl).thumbnail(thumbnailUrl).expiresIn(expire).build();
    }

    default public String generatePath(String fileName) {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMM")) + "/" + PathUtil.generatePath(fileName) + "/" + fileName;
    }

    /*
     * Exception decompiling
     */
    default public UploadResult uploadFromUri(String uri, boolean keepPublic, boolean thumbnail) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    default public String contentTypeByFileName(String name) {
        return TYPE_CACHE.getOrDefault(FileUtil.getFileSuffix(name), ContentType.APPLICATION_OCTET_STREAM.getMimeType());
    }

    default public String suffixByContentType(String contentType) {
        AtomicReference<Object> suffix = new AtomicReference<Object>(null);
        TYPE_CACHE.forEach((k, v) -> {
            if (v.equals(contentType)) {
                suffix.set(k);
            }
        });
        return suffix.get();
    }

    public String getEndpoint();

    default public String getPublicBucket() {
        return this.getBucket(true);
    }

    public String getBucket(boolean var1);

    default public DocumentUrlResult getPublicDocumentUrl(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            String endpoint = this.getEndpoint();
            String url = endpoint + "/" + this.getPublicBucket() + "/" + key;
            return DocumentUrlResult.builder().url(url).thumbnail(ImageUtil.appendSuffixHyphenThumbnail(url)).build();
        }
        return DocumentUrlResult.builder().build();
    }
}

