/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.util;

import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public class AopTargetUtils {
    public static Object getTarget(Object proxy) {
        Object obj;
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        try {
            obj = AopUtils.isJdkDynamicProxy((Object)proxy) ? AopTargetUtils.getJdkDynamicProxyTargetObject(proxy) : AopTargetUtils.getCglibProxyTargetObject(proxy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return obj == null ? proxy : obj;
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }
}

