/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.controller;

import cn.ciphermagic.common.controller.DynamicController;
import cn.ciphermagic.common.controller.EnableDynamicController;
import cn.ciphermagic.common.util.ClassScanner;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DynamicControllerRegistry
extends ApplicationObjectSupport
implements BeanDefinitionRegistryPostProcessor {
    private String basePackage;

    protected void initApplicationContext(ApplicationContext context) {
        super.initApplicationContext(context);
        this.findBasePackage(context);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        if (StringUtils.isEmpty((Object)this.basePackage)) {
            throw new IllegalArgumentException("could not find EnableDynamicController annotation.");
        }
        ClassScanner.scan(this.basePackage, DynamicController.class).forEach(serviceClass -> {
            Class<?> apiClass = this.getImplementedClass((Class<?>)serviceClass);
            String className = this.assembleClassName(serviceClass.getName(), apiClass.getSimpleName());
            Class clazz = this.makeClass(className, apiClass, (Class)serviceClass);
            BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)clazz.getName());
            beanDefinitionRegistry.registerBeanDefinition(clazz.getName(), (BeanDefinition)definitionBuilder.getBeanDefinition());
        });
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    private void findBasePackage(ApplicationContext applicationContext) {
        Map map = applicationContext.getBeansWithAnnotation(EnableDynamicController.class);
        if (map == null) {
            throw new IllegalArgumentException("could not found EnableDynamicController annotation.");
        }
        if (map.size() != 1) {
            throw new IllegalArgumentException("found more than 1 EnableDynamicController annotation.");
        }
        Object obj = map.values().iterator().next();
        EnableDynamicController annotation = obj.getClass().getAnnotation(EnableDynamicController.class);
        this.basePackage = annotation != null && !StringUtils.isEmpty((Object)annotation.value()) ? annotation.value() : obj.getClass().getPackage().getName();
    }

    private Class<?> getImplementedClass(Class<?> serviceClass) {
        Class apiClass = serviceClass.getAnnotation(DynamicController.class).value();
        if (apiClass == String.class) {
            return serviceClass.getInterfaces()[0];
        }
        return apiClass;
    }

    private String assembleClassName(String serviceClass, String apiName) {
        int index = serviceClass.lastIndexOf(".") + 1;
        serviceClass = serviceClass.substring(0, index);
        return serviceClass + apiName + "Controller";
    }

    private Class makeClass(String className, Class apiClass, Class serviceClass) {
        Class clazz;
        ClassPool pool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(((Object)((Object)this)).getClass());
        pool.insertClassPath((ClassPath)classPath);
        CtClass cc = pool.makeClass(className);
        ClassFile ccFile = cc.getClassFile();
        ConstPool constpool = ccFile.getConstPool();
        try {
            Method[] methods;
            CtClass apiCtClass = pool.get(apiClass.getName());
            cc.addInterface(pool.getCtClass(apiClass.getName()));
            AnnotationsAttribute classAttr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation controller = new Annotation("org.springframework.web.bind.annotation.RestController", constpool);
            classAttr.addAnnotation(controller);
            ccFile.addAttribute((AttributeInfo)classAttr);
            CtField serviceField = new CtField(pool.getCtClass(serviceClass.getName()), "service", cc);
            serviceField.setModifiers(2);
            FieldInfo fieldInfo = serviceField.getFieldInfo();
            AnnotationsAttribute fieldAttr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation autowired = new Annotation("org.springframework.beans.factory.annotation.Autowired", constpool);
            fieldAttr.addAnnotation(autowired);
            fieldInfo.addAttribute((AttributeInfo)fieldAttr);
            cc.addField(serviceField);
            for (Method m : methods = apiClass.getMethods()) {
                List attributes;
                CtMethod apiMethod = apiCtClass.getDeclaredMethod(m.getName());
                CtClass[] parameterTypes = apiMethod.getParameterTypes();
                CtClass returnType = pool.get(m.getReturnType().getName());
                CtMethod ctMethod = new CtMethod(returnType, m.getName(), parameterTypes, cc);
                ctMethod.setModifiers(1);
                if (apiMethod.getGenericSignature() != null) {
                    ctMethod.setGenericSignature(apiMethod.getGenericSignature());
                }
                if (!CollectionUtils.isEmpty((Collection)(attributes = apiMethod.getMethodInfo().getAttributes()))) {
                    for (Object attr : attributes) {
                        ctMethod.getMethodInfo().addAttribute((AttributeInfo)attr);
                    }
                }
                StringBuilder paramBody = new StringBuilder("(");
                if (parameterTypes != null && parameterTypes.length > 0) {
                    for (int i = 1; i <= parameterTypes.length; ++i) {
                        paramBody.append("$").append(i);
                        paramBody.append(i == parameterTypes.length ? "" : ",");
                    }
                }
                paramBody.append(")");
                String body = "{\nreturn service." + m.getName() + paramBody.toString() + ";\n}";
                ctMethod.setBody(body);
                cc.addMethod(ctMethod);
            }
            clazz = cc.toClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return clazz;
    }
}

