/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.checker;

import cn.ciphermagic.common.checker.Check;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMethodMatcher;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CheckerInterceptor
implements MethodInterceptor {
    private static final String SEPARATOR = ":";
    private static final Map<String, String[]> DYNAMIC_FIELDS = new ConcurrentHashMap<String, String[]>();
    private final ExpressionParser parser = new SpelExpressionParser();
    private final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private Function<String, Object> unsuccessful;

    private CheckerInterceptor() {
    }

    public void setUnsuccessful(Function<String, Object> unsuccessful) {
        this.unsuccessful = unsuccessful;
    }

    public static void updateDynamicField(String key, String[] value) {
        DYNAMIC_FIELDS.put(key, value);
    }

    public static void removeDynamicField(String key) {
        DYNAMIC_FIELDS.remove(key);
    }

    public static Advisor checkAdvisor(Function<String, Object> unsuccessful) {
        AnnotationMethodMatcher annotatedMethodOrTargetClassMatcher = new AnnotationMethodMatcher(Check.class, true){

            public boolean matches(Method method, Class<?> targetClass) {
                if (AnnotatedElementUtils.hasAnnotation(targetClass, Check.class)) {
                    return true;
                }
                return super.matches(method, targetClass);
            }
        };
        return new DefaultPointcutAdvisor((Pointcut)new ComposablePointcut((MethodMatcher)annotatedMethodOrTargetClassMatcher), (Advice)CheckerInterceptor.builder().unsuccessful(unsuccessful).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String msg = this.doCheck(invocation);
        if (!StringUtils.isEmpty((Object)msg)) {
            return this.unsuccessful.apply(msg);
        }
        Object obj = invocation.proceed();
        return obj;
    }

    private String doCheck(MethodInvocation invocation) {
        Object[] arguments = invocation.getArguments();
        Method method = invocation.getMethod();
        String methodInfo = StringUtils.isEmpty((Object)method.getName()) ? "" : " while calling " + method.getName();
        String msg = "";
        List<Check> checks = this.getChecks(method);
        List<String> fields = this.getFixedFields(checks);
        fields.addAll(this.getDynamicFields(checks));
        fields = fields.stream().filter(f -> !StringUtils.isEmpty((Object)f)).collect(Collectors.toList());
        if (arguments.length == 0) {
            msg = "param can not be null";
        } else if (!CollectionUtils.isEmpty(fields)) {
            Object vo = arguments[0];
            for (String field : fields) {
                Boolean isValid;
                FieldInfo info = this.resolveField(field, methodInfo);
                if (info.optEnum == Operator.SPEL) {
                    isValid = this.parseSpel(method, arguments, info.field);
                } else {
                    String getMethodName = "get" + StringUtils.capitalize((String)info.field);
                    Method getMethod = ReflectionUtils.findMethod(vo.getClass(), (String)getMethodName);
                    if (getMethod == null) break;
                    Object value = ReflectionUtils.invokeMethod((Method)getMethod, (Object)vo);
                    isValid = (Boolean)info.optEnum.fun.apply(value, info.operatorNum);
                }
                if (isValid.booleanValue()) continue;
                msg = info.innerMsg;
                break;
            }
        }
        return msg;
    }

    private Boolean parseSpel(Method method, Object[] arguments, String spel) {
        String[] params = this.discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (params == null || params.length == 0) {
            return Boolean.FALSE;
        }
        for (int len = 0; len < params.length; ++len) {
            context.setVariable(params[len], arguments[len]);
        }
        try {
            Expression expression = this.parser.parseExpression(spel);
            return (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private FieldInfo resolveField(String fieldStr, String methodInfo) {
        FieldInfo fieldInfo = new FieldInfo();
        String innerMsg = "";
        if (fieldStr.contains(SEPARATOR)) {
            if (fieldStr.split(SEPARATOR).length == 2) {
                innerMsg = fieldStr.split(SEPARATOR)[1].trim();
                fieldStr = fieldStr.split(SEPARATOR)[0].trim();
            } else {
                throw new IllegalArgumentException("@Check annotation error: " + fieldStr);
            }
        }
        fieldInfo.optEnum = fieldStr.startsWith("#") || fieldStr.startsWith("T(") ? Operator.SPEL : (fieldStr.contains(Operator.GREATER_THAN_EQUAL.value) ? Operator.GREATER_THAN_EQUAL : (fieldStr.contains(Operator.LESS_THAN_EQUAL.value) ? Operator.LESS_THAN_EQUAL : (fieldStr.contains(Operator.GREATER_THAN.value) ? Operator.GREATER_THAN : (fieldStr.contains(Operator.LESS_THAN.value) ? Operator.LESS_THAN : (fieldStr.contains(Operator.NOT_EQUAL.value) ? Operator.NOT_EQUAL : Operator.NOT_NULL)))));
        if (fieldInfo.optEnum == Operator.NOT_NULL || fieldInfo.optEnum == Operator.SPEL) {
            fieldInfo.field = fieldStr;
        } else {
            fieldInfo.field = fieldStr.split(fieldInfo.optEnum.value)[0];
            fieldInfo.operatorNum = fieldStr.split(fieldInfo.optEnum.value)[1];
        }
        fieldInfo.operator = fieldInfo.optEnum.value;
        String operatorNum = fieldInfo.operatorNum == null ? "" : " " + fieldInfo.operatorNum;
        String defaultMsg = fieldInfo.field + " must " + fieldInfo.operator + operatorNum + methodInfo;
        fieldInfo.innerMsg = StringUtils.isEmpty((Object)innerMsg) ? defaultMsg : innerMsg;
        return fieldInfo;
    }

    private static Boolean isNotNull(Object value, String operatorNum) {
        Boolean isNotNull = Boolean.TRUE;
        Boolean isStringNull = value instanceof String && StringUtils.isEmpty((Object)value);
        Boolean isCollectionNull = value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value));
        if (value == null) {
            isNotNull = Boolean.FALSE;
        } else if (isStringNull.booleanValue() || isCollectionNull.booleanValue()) {
            isNotNull = Boolean.FALSE;
        }
        return isNotNull;
    }

    private static Boolean isGreaterThan(Object value, String operatorNum) {
        boolean isCollectionGreaterThen;
        Boolean isGreaterThan = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        boolean isStringGreaterThen = value instanceof String && ((String)value).length() > Integer.parseInt(operatorNum);
        boolean isLongGreaterThen = value instanceof Long && (Long)value > Long.parseLong(operatorNum);
        boolean isIntegerGreaterThen = value instanceof Integer && (Integer)value > Integer.parseInt(operatorNum);
        boolean isShortGreaterThen = value instanceof Short && (Short)value > Short.parseShort(operatorNum);
        boolean isFloatGreaterThen = value instanceof Float && ((Float)value).floatValue() > Float.parseFloat(operatorNum);
        boolean isDoubleGreaterThen = value instanceof Double && (Double)value > Double.parseDouble(operatorNum);
        boolean bl = isCollectionGreaterThen = value instanceof Collection && ((Collection)value).size() > Integer.parseInt(operatorNum);
        if (isStringGreaterThen || isLongGreaterThen || isIntegerGreaterThen || isShortGreaterThen || isFloatGreaterThen || isDoubleGreaterThen || isCollectionGreaterThen) {
            isGreaterThan = Boolean.TRUE;
        }
        return isGreaterThan;
    }

    private static Boolean isGreaterThanEqual(Object value, String operatorNum) {
        boolean isCollectionGreaterThenEqual;
        Boolean isGreaterThanEqual = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        boolean isStringGreaterThenEqual = value instanceof String && ((String)value).length() >= Integer.parseInt(operatorNum);
        boolean isLongGreaterThenEqual = value instanceof Long && (Long)value >= Long.parseLong(operatorNum);
        boolean isIntegerGreaterThenEqual = value instanceof Integer && (Integer)value >= Integer.parseInt(operatorNum);
        boolean isShortGreaterThenEqual = value instanceof Short && (Short)value >= Short.parseShort(operatorNum);
        boolean isFloatGreaterThenEqual = value instanceof Float && ((Float)value).floatValue() >= Float.parseFloat(operatorNum);
        boolean isDoubleGreaterThenEqual = value instanceof Double && (Double)value >= Double.parseDouble(operatorNum);
        boolean bl = isCollectionGreaterThenEqual = value instanceof Collection && ((Collection)value).size() >= Integer.parseInt(operatorNum);
        if (isStringGreaterThenEqual || isLongGreaterThenEqual || isIntegerGreaterThenEqual || isShortGreaterThenEqual || isFloatGreaterThenEqual || isDoubleGreaterThenEqual || isCollectionGreaterThenEqual) {
            isGreaterThanEqual = Boolean.TRUE;
        }
        return isGreaterThanEqual;
    }

    private static Boolean isLessThan(Object value, String operatorNum) {
        boolean isCollectionLessThen;
        Boolean isLessThan = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        boolean isStringLessThen = value instanceof String && ((String)value).length() < Integer.parseInt(operatorNum);
        boolean isLongLessThen = value instanceof Long && (Long)value < Long.parseLong(operatorNum);
        boolean isIntegerLessThen = value instanceof Integer && (Integer)value < Integer.parseInt(operatorNum);
        boolean isShortLessThen = value instanceof Short && (Short)value < Short.parseShort(operatorNum);
        boolean isFloatLessThen = value instanceof Float && ((Float)value).floatValue() < Float.parseFloat(operatorNum);
        boolean isDoubleLessThen = value instanceof Double && (Double)value < Double.parseDouble(operatorNum);
        boolean bl = isCollectionLessThen = value instanceof Collection && ((Collection)value).size() < Integer.parseInt(operatorNum);
        if (isStringLessThen || isLongLessThen || isIntegerLessThen || isShortLessThen || isFloatLessThen || isDoubleLessThen || isCollectionLessThen) {
            isLessThan = Boolean.TRUE;
        }
        return isLessThan;
    }

    private static Boolean isLessThanEqual(Object value, String operatorNum) {
        boolean isCollectionLessThenEqual;
        Boolean isLessThanEqual = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        boolean isStringLessThenEqual = value instanceof String && ((String)value).length() <= Integer.parseInt(operatorNum);
        boolean isLongLessThenEqual = value instanceof Long && (Long)value <= Long.parseLong(operatorNum);
        boolean isIntegerLessThenEqual = value instanceof Integer && (Integer)value <= Integer.parseInt(operatorNum);
        boolean isShortLessThenEqual = value instanceof Short && (Short)value <= Short.parseShort(operatorNum);
        boolean isFloatLessThenEqual = value instanceof Float && ((Float)value).floatValue() <= Float.parseFloat(operatorNum);
        boolean isDoubleLessThenEqual = value instanceof Double && (Double)value <= Double.parseDouble(operatorNum);
        boolean bl = isCollectionLessThenEqual = value instanceof Collection && ((Collection)value).size() <= Integer.parseInt(operatorNum);
        if (isStringLessThenEqual || isLongLessThenEqual || isIntegerLessThenEqual || isShortLessThenEqual || isFloatLessThenEqual || isDoubleLessThenEqual || isCollectionLessThenEqual) {
            isLessThanEqual = Boolean.TRUE;
        }
        return isLessThanEqual;
    }

    private static Boolean isNotEqual(Object value, String operatorNum) {
        boolean isCollectionNotEqual;
        Boolean isNotEqual = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        boolean isStringNotEqual = value instanceof String && !value.equals(operatorNum);
        boolean isLongNotEqual = value instanceof Long && !value.equals(Long.valueOf(operatorNum));
        boolean isIntegerNotEqual = value instanceof Integer && !value.equals(Integer.valueOf(operatorNum));
        boolean isShortNotEqual = value instanceof Short && !value.equals(Short.valueOf(operatorNum));
        boolean isFloatNotEqual = value instanceof Float && !value.equals(Float.valueOf(operatorNum));
        boolean isDoubleNotEqual = value instanceof Double && !value.equals(Double.valueOf(operatorNum));
        boolean bl = isCollectionNotEqual = value instanceof Collection && ((Collection)value).size() != Integer.parseInt(operatorNum);
        if (isStringNotEqual || isLongNotEqual || isIntegerNotEqual || isShortNotEqual || isFloatNotEqual || isDoubleNotEqual || isCollectionNotEqual) {
            isNotEqual = Boolean.TRUE;
        }
        return isNotEqual;
    }

    private List<Check> getChecks(Method method) {
        ArrayList<Check> list = new ArrayList<Check>();
        if (CollectionUtils.isEmpty(list)) {
            MergedAnnotations.from((AnnotatedElement)method).stream(Check.class).filter(MergedAnnotation::isPresent).map(MergedAnnotation::synthesize).forEach(list::add);
            MergedAnnotations.from(method.getDeclaringClass()).stream(Check.class).filter(MergedAnnotation::isPresent).map(MergedAnnotation::synthesize).forEach(list::add);
        }
        return list;
    }

    private List<String> getFixedFields(List<Check> checks) {
        ArrayList<String> list = new ArrayList<String>();
        checks.stream().map(Check::value).forEach(strings -> list.addAll(Arrays.asList(strings)));
        return list;
    }

    private List<String> getDynamicFields(List<Check> checks) {
        ArrayList<String> list = new ArrayList<String>();
        checks.stream().map(Check::dynamic).filter(dynamic -> !StringUtils.isEmpty((Object)dynamic)).map(DYNAMIC_FIELDS::get).filter(s -> !StringUtils.isEmpty((Object)s)).forEach(values -> list.addAll(Arrays.asList(values)));
        return list;
    }

    static enum Operator {
        SPEL("match spel expression", null),
        GREATER_THAN(">", (x$0, x$1) -> CheckerInterceptor.access$800(x$0, x$1)),
        GREATER_THAN_EQUAL(">=", (x$0, x$1) -> CheckerInterceptor.access$700(x$0, x$1)),
        LESS_THAN("<", (x$0, x$1) -> CheckerInterceptor.access$600(x$0, x$1)),
        LESS_THAN_EQUAL("<=", (x$0, x$1) -> CheckerInterceptor.access$500(x$0, x$1)),
        NOT_EQUAL("!=", (x$0, x$1) -> CheckerInterceptor.access$400(x$0, x$1)),
        NOT_NULL("not null", (x$0, x$1) -> CheckerInterceptor.access$300(x$0, x$1));

        private final String value;
        private final BiFunction<Object, String, Boolean> fun;

        private Operator(String value, BiFunction<Object, String, Boolean> fun) {
            this.value = value;
            this.fun = fun;
        }
    }

    static class FieldInfo {
        String field;
        String innerMsg;
        String operator;
        String operatorNum;
        Operator optEnum;

        FieldInfo() {
        }
    }

    public static class Builder {
        private final CheckerInterceptor checker = new CheckerInterceptor();

        public Builder unsuccessful(Function<String, Object> unsuccessful) {
            this.checker.setUnsuccessful(unsuccessful);
            return this;
        }

        public CheckerInterceptor build() {
            return this.checker;
        }
    }
}

