/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class ClassScanner
implements ResourceLoaderAware {
    private final List<TypeFilter> includeFilters = new LinkedList<TypeFilter>();
    private final List<TypeFilter> excludeFilters = new LinkedList<TypeFilter>();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    @SafeVarargs
    public static Set<Class<?>> scan(String[] basePackages, Class<? extends Annotation> ... annotations) {
        ClassScanner cs = new ClassScanner();
        if (annotations != null && annotations.length != 0) {
            for (Class<? extends Annotation> a : annotations) {
                cs.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(a));
            }
        }
        HashSet classes = new HashSet();
        for (String s : basePackages) {
            classes.addAll(cs.doScan(s));
        }
        return classes;
    }

    @SafeVarargs
    public static Set<Class<?>> scan(String basePackages, Class<? extends Annotation> ... annotations) {
        return ClassScanner.scan(StringUtils.tokenizeToStringArray((String)basePackages, (String)",; \t\n"), annotations);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void addIncludeFilter(TypeFilter includeFilter) {
        this.includeFilters.add(includeFilter);
    }

    public void addExcludeFilter(TypeFilter includeFilter) {
        this.excludeFilters.add(includeFilter);
    }

    public Set<Class<?>> doScan(String basePackage) {
        HashSet classes = new HashSet();
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage)) + "/**/*.class";
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                if ((this.includeFilters.size() != 0 || this.excludeFilters.size() != 0) && !this.matches(metadataReader)) continue;
                try {
                    classes.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
        return classes;
    }

    protected boolean matches(MetadataReader metadataReader) throws IOException {
        for (TypeFilter tf : this.excludeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return false;
        }
        for (TypeFilter tf : this.includeFilters) {
            if (!tf.match(metadataReader, this.metadataReaderFactory)) continue;
            return true;
        }
        return false;
    }
}

