/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ReflectionUtil {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Object invokeGetter(Object obj, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.invokeMethod(obj, getterMethodName, new Class[0], new Object[0]);
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        ReflectionUtil.invokeMethodByName(obj, setterMethodName, new Object[]{value});
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtil.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtil.getAccessibleField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethodByName(obj, methodName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Field getAccessibleField(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectionUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                ReflectionUtil.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectionUtil.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static void setFieldValue2(Object obj, String fieldPath, Object value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        int pos = -1;
        if (fieldPath.contains(".")) {
            pos = fieldPath.indexOf(".");
        }
        if (pos != -1) {
            String nestedProperty = fieldPath.substring(0, pos);
            String nestedPath = fieldPath.substring(pos);
            Field nestPropertyField = obj.getClass().getDeclaredField(nestedProperty);
            nestPropertyField.setAccessible(true);
            if (nestPropertyField.get(obj) == null) {
                Object nestedPropertyValue = nestPropertyField.getType().newInstance();
                nestPropertyField.set(obj, nestedPropertyValue);
                ReflectionUtil.setFieldValue2(nestedPropertyValue, nestedPath.substring(1), value);
            } else {
                ReflectionUtil.setFieldValue2(nestPropertyField.get(obj), nestedPath.substring(1), value);
            }
        } else {
            ReflectionUtil.invokeSetter(obj, fieldPath, value);
        }
    }

    public static Object getFieldValue2(Object obj, String fieldPath) throws NoSuchFieldException, IllegalAccessException {
        if (obj == null) {
            return null;
        }
        int pos = -1;
        if (fieldPath.contains(".")) {
            pos = fieldPath.indexOf(".");
        }
        if (pos != -1) {
            String nestedProperty = fieldPath.substring(0, pos);
            String nestedPath = fieldPath.substring(pos);
            Field nestPropertyField = obj.getClass().getDeclaredField(nestedProperty);
            nestPropertyField.setAccessible(true);
            return ReflectionUtil.getFieldValue2(nestPropertyField.get(obj), nestedPath.substring(1));
        }
        return ReflectionUtil.invokeGetter(obj, fieldPath);
    }
}

