/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ObjAdapter.class);

    public static <A, B> List<B> convert(Collection<A> collection, Class<B> targetClass, BiConsumer<A, B> decorator) {
        if (collection == null || collection.size() == 0) {
            return new ArrayList();
        }
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return collection.stream().map(a -> {
            Object b = om.convertValue(a, targetClass);
            decorator.accept(a, b);
            return b;
        }).collect(Collectors.toList());
    }

    public static <A, B> List<B> convert(Collection<A> collection, Class<B> targetClass) {
        if (collection == null || collection.size() == 0) {
            return new ArrayList();
        }
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return collection.stream().map(a -> om.convertValue(a, targetClass)).collect(Collectors.toList());
    }

    public static <V, T> T convert(Object a, Class<T> targetClass, BiConsumer<V, T> decorator) {
        T b = null;
        if (a == null) {
            try {
                b = targetClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("" + e);
            }
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(a);
            List<T> result = ObjAdapter.convert(list, targetClass, decorator);
            b = result.get(0);
        }
        return b;
    }

    public static <T> T convert(Object a, Class<T> targetClass) {
        Object b = null;
        if (a == null) {
            try {
                b = targetClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("" + e);
            }
        } else {
            ObjectMapper om = new ObjectMapper();
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            b = om.convertValue(a, targetClass);
        }
        return (T)b;
    }
}

