/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileOperateUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileOperateUtil.class);
    public static final int BUFSIZE = 0x100000;
    public static final String DEFAULT_ENCODING = "UTF-8";

    public static File downloadFile(String fileUrl) {
        String fileLocal = System.getProperty("java.io.tmpdir") + File.separator + FileOperateUtil.rename(fileUrl);
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection urlCon = (HttpURLConnection)url.openConnection();
            urlCon.setConnectTimeout(6000);
            urlCon.setReadTimeout(6000);
            urlCon.setRequestProperty("Referer", "https://admin.tupperware.net.cn");
            int code = urlCon.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
            }
            DataInputStream in = new DataInputStream(urlCon.getInputStream());
            DataOutputStream out = new DataOutputStream(new FileOutputStream(fileLocal));
            byte[] buffer = new byte[2048];
            int count = 0;
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
            out.close();
            in.close();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        File file = new File(fileLocal);
        if (!file.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25");
        }
        return file;
    }

    public static boolean deleteFiles(String[] files) {
        boolean isSuccess = false;
        for (String f : files) {
            File file = new File(f);
            if (!file.exists()) continue;
            isSuccess = file.delete();
        }
        return isSuccess;
    }

    public static boolean deleteFiles(List<File> files) {
        boolean isSuccess = false;
        for (File f : files) {
            if (!f.exists()) continue;
            isSuccess = f.getAbsoluteFile().delete();
        }
        return isSuccess;
    }

    public static boolean deleteFile(File file) {
        boolean isSuccess = false;
        if (file != null && file.exists()) {
            file.delete();
        }
        return isSuccess;
    }

    public static String rename(String name) {
        Long now = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        Long random = (long)(Math.random() * (double)now.longValue());
        String fileName = now + random + "";
        if (name.indexOf(".") != -1) {
            fileName = fileName + name.substring(name.lastIndexOf("."));
        }
        return fileName;
    }

    public static String suffix(String name) {
        String suffix = "";
        if (name.lastIndexOf(".") != -1) {
            suffix = name.substring(name.lastIndexOf(".") + 1);
        }
        return suffix;
    }

    public static String getBaseName(String name) {
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String zipName(String name) {
        String prefix = "";
        prefix = -1 == name.lastIndexOf(".") ? name : name.substring(0, name.lastIndexOf("."));
        return prefix + ".zip";
    }

    public static void mergeFiles(String outFile, String[] files) {
        FileChannel outChannel = null;
        FileInputStream fis = null;
        FileChannel fc = null;
        try {
            outChannel = new FileOutputStream(outFile).getChannel();
            for (String f : files) {
                fis = new FileInputStream(f);
                fc = fis.getChannel();
                ByteBuffer bb = ByteBuffer.allocate(8192);
                while (fc.read(bb) != -1) {
                    bb.flip();
                    outChannel.write(bb);
                    bb.clear();
                }
            }
        }
        catch (IOException e) {
            try {
                LOG.error("", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeResource(outChannel);
                FileOperateUtil.closeResource(fis);
                FileOperateUtil.closeResource(fc);
                throw throwable;
            }
        }
        FileOperateUtil.closeResource(outChannel);
        FileOperateUtil.closeResource(fis);
        FileOperateUtil.closeResource(fc);
    }

    public static void closeResource(Closeable res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public static boolean makeDir(String dir) {
        boolean isSuccess = true;
        File file = new File(dir);
        if (!file.exists() && !file.isDirectory()) {
            isSuccess = file.mkdirs();
        }
        return isSuccess;
    }

    public static byte[] getBytes(MultipartFile file) {
        byte[] bytes = null;
        try {
            bytes = file.getBytes();
        }
        catch (IOException e) {
            LOG.error("" + e);
            throw new RuntimeException(e.getMessage());
        }
        return bytes;
    }

    public static int copy(String fileFullName, MultipartFile mFile) {
        int byteCount = 0;
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fileFullName));
            in = mFile.getInputStream();
            byteCount = FileCopyUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                LOG.error("" + e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeResource(in);
                FileOperateUtil.closeResource(out);
                throw throwable;
            }
        }
        FileOperateUtil.closeResource(in);
        FileOperateUtil.closeResource(out);
        return byteCount;
    }

    public static int copy(File file, MultipartFile mFile) {
        int byteCount = 0;
        BufferedOutputStream out = null;
        InputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            in = mFile.getInputStream();
            byteCount = FileCopyUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                LOG.error("" + e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeResource(in);
                FileOperateUtil.closeResource(out);
                throw throwable;
            }
        }
        FileOperateUtil.closeResource(in);
        FileOperateUtil.closeResource(out);
        return byteCount;
    }

    public static OutputStream getOutputStream(HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            LOG.error("" + e);
            throw new RuntimeException(e.getMessage());
        }
        return out;
    }

    public static void flush(OutputStream os) {
        try {
            os.flush();
        }
        catch (IOException e) {
            LOG.error("" + e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            FileOperateUtil.closeResource(os);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(String str, String filePath) {
        byte[] buff = new byte[]{};
        FileOutputStream out = null;
        buff = str.getBytes();
        try {
            out = new FileOutputStream(filePath);
            out.write(buff, 0, buff.length);
        }
        catch (FileNotFoundException e) {
            try {
                LOG.error("" + e);
                throw new RuntimeException(e.getMessage());
                catch (IOException e2) {
                    LOG.error("" + e2);
                    throw new RuntimeException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeResource(out);
                throw throwable;
            }
        }
        FileOperateUtil.closeResource(out);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(String filePath) {
        String str = null;
        CharBuffer cbuf = null;
        FileReader fReader = null;
        File file = new File(filePath);
        try {
            fReader = new FileReader(file);
            cbuf = CharBuffer.allocate((int)file.length());
            fReader.read(cbuf);
            str = new String(cbuf.array());
        }
        catch (FileNotFoundException e) {
            try {
                LOG.error("" + e);
                throw new RuntimeException(e.getMessage());
                catch (IOException e2) {
                    LOG.error("" + e2);
                    throw new RuntimeException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                FileOperateUtil.closeResource(fReader);
                throw throwable;
            }
        }
        FileOperateUtil.closeResource(fReader);
        return str;
    }

    public static void deleteDir(String delpath, long interval) {
        File file = new File(delpath);
        if (file.isDirectory()) {
            String[] filelist = file.list();
            for (int i = 0; i < filelist.length; ++i) {
                File delfile = new File(delpath + File.separator + filelist[i]);
                long lastModified = delfile.lastModified();
                long now = System.currentTimeMillis();
                if (now - lastModified <= interval) continue;
                if (!delfile.isDirectory()) {
                    delfile.delete();
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                FileOperateUtil.deleteDir(delpath + File.separator + filelist[i], interval);
            }
        }
    }
}

