/*
 * Decompiled with CFR 0.152.
 */
package cn.ciphermagic.common.checker;

import cn.ciphermagic.common.checker.Check;
import cn.ciphermagic.common.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Aspect
public class CheckParamAspect {
    private static final Logger LOG = LoggerFactory.getLogger(CheckParamAspect.class);
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private Function<String, Object> unsuccessful;
    private static final String SPLITOR = ":";
    private static final String FIELD_SPLITOR = ",";

    private CheckParamAspect() {
    }

    public void setUnsuccessful(Function<String, Object> unsuccessful) {
        this.unsuccessful = unsuccessful;
    }

    public CheckParamAspect build(Function<String, Object> unsuccessful) {
        CheckParamAspect aspect = new CheckParamAspect();
        aspect.setUnsuccessful(unsuccessful);
        return aspect;
    }

    @Around(value="@annotation(com.tupperware.pos.common.annotation.Check)")
    public Object check(ProceedingJoinPoint point) throws Throwable {
        String msg = this.doCheck(point);
        if (!StringUtils.isEmpty((Object)msg)) {
            return this.unsuccessful.apply(msg);
        }
        Object obj = point.proceed();
        return obj;
    }

    private String doCheck(ProceedingJoinPoint point) {
        Object[] arguments = point.getArgs();
        Method method = this.getMethod(point);
        String methodInfo = StringUtils.isEmpty((Object)method.getName()) ? "" : " while calling " + method.getName();
        String msg = "";
        if (this.isCheck(method, arguments).booleanValue()) {
            Check annotation = method.getAnnotation(Check.class);
            String[] fields = annotation.value();
            Object vo = arguments[0];
            if (vo == null) {
                msg = "param can not be null";
            } else {
                for (String field : fields) {
                    Boolean isValid;
                    FieldInfo info = this.resolveField(field, methodInfo);
                    if (info.optEnum == Operator.SPEL) {
                        isValid = this.parseSpel(method, arguments, info.field);
                    } else {
                        Object value = ReflectionUtil.invokeGetter(vo, info.field);
                        isValid = (Boolean)info.optEnum.fun.apply(value, info.operatorNum);
                    }
                    if (isValid.booleanValue()) continue;
                    msg = info.innerMsg;
                    break;
                }
            }
        }
        return msg;
    }

    private Boolean parseSpel(Method method, Object[] arguments, String spel) {
        String[] params = this.discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int len = 0; len < params.length; ++len) {
            context.setVariable(params[len], arguments[len]);
        }
        try {
            Expression expression = this.parser.parseExpression(spel);
            return (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private FieldInfo resolveField(String fieldStr, String methodInfo) {
        FieldInfo fieldInfo = new FieldInfo();
        String innerMsg = "";
        if (fieldStr.contains(SPLITOR)) {
            innerMsg = fieldStr.split(SPLITOR)[1];
            fieldStr = fieldStr.split(SPLITOR)[0];
        }
        fieldInfo.optEnum = fieldStr.startsWith("#") ? Operator.SPEL : (fieldStr.contains(Operator.GREATER_THAN_EQUAL.value) ? Operator.GREATER_THAN_EQUAL : (fieldStr.contains(Operator.LESS_THAN_EQUAL.value) ? Operator.LESS_THAN_EQUAL : (fieldStr.contains(Operator.GREATER_THAN.value) ? Operator.GREATER_THAN : (fieldStr.contains(Operator.LESS_THAN.value) ? Operator.LESS_THAN : (fieldStr.contains(Operator.NOT_EQUAL.value) ? Operator.NOT_EQUAL : Operator.NOT_NULL)))));
        if (fieldInfo.optEnum == Operator.NOT_NULL || fieldInfo.optEnum == Operator.SPEL) {
            fieldInfo.field = fieldStr;
        } else {
            fieldInfo.field = fieldStr.split(fieldInfo.optEnum.value)[0];
            fieldInfo.operatorNum = fieldStr.split(fieldInfo.optEnum.value)[1];
        }
        fieldInfo.operator = fieldInfo.optEnum.value;
        String operatorNum = fieldInfo.operatorNum == null ? "" : " " + fieldInfo.operatorNum;
        String defaultMsg = fieldInfo.field + " must " + fieldInfo.operator + operatorNum + methodInfo;
        fieldInfo.innerMsg = StringUtils.isEmpty((Object)innerMsg) ? defaultMsg : innerMsg;
        return fieldInfo;
    }

    private static Boolean isNotNull(Object value, String operatorNum) {
        Boolean isNotNull = Boolean.TRUE;
        Boolean isStringNull = value instanceof String && StringUtils.isEmpty((Object)((String)value));
        Boolean isCollectionNull = value instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)value));
        if (value == null) {
            isNotNull = Boolean.FALSE;
        } else if (isStringNull.booleanValue() || isCollectionNull.booleanValue()) {
            isNotNull = Boolean.FALSE;
        }
        return isNotNull;
    }

    private static Boolean isGreaterThan(Object value, String operatorNum) {
        Boolean isGreaterThan = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        Boolean isStringGreaterThen = value instanceof String && ((String)value).length() > Integer.valueOf(operatorNum);
        Boolean isLongGreaterThen = value instanceof Long && (Long)value > Long.valueOf(operatorNum);
        Boolean isIntegerGreaterThen = value instanceof Integer && (Integer)value > Integer.valueOf(operatorNum);
        Boolean isShortGreaterThen = value instanceof Short && (Short)value > Short.valueOf(operatorNum);
        Boolean isFloatGreaterThen = value instanceof Float && ((Float)value).floatValue() > Float.valueOf(operatorNum).floatValue();
        Boolean isDoubleGreaterThen = value instanceof Double && (Double)value > Double.valueOf(operatorNum);
        Boolean isCollectionGreaterThen = value instanceof Collection && ((Collection)value).size() > Integer.valueOf(operatorNum);
        if (isStringGreaterThen.booleanValue() || isLongGreaterThen.booleanValue() || isIntegerGreaterThen.booleanValue() || isShortGreaterThen.booleanValue() || isFloatGreaterThen.booleanValue() || isDoubleGreaterThen.booleanValue() || isCollectionGreaterThen.booleanValue()) {
            isGreaterThan = Boolean.TRUE;
        }
        return isGreaterThan;
    }

    private static Boolean isGreaterThanEqual(Object value, String operatorNum) {
        Boolean isGreaterThanEqual = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        Boolean isStringGreaterThenEqual = value instanceof String && ((String)value).length() >= Integer.valueOf(operatorNum);
        Boolean isLongGreaterThenEqual = value instanceof Long && (Long)value >= Long.valueOf(operatorNum);
        Boolean isIntegerGreaterThenEqual = value instanceof Integer && (Integer)value >= Integer.valueOf(operatorNum);
        Boolean isShortGreaterThenEqual = value instanceof Short && (Short)value >= Short.valueOf(operatorNum);
        Boolean isFloatGreaterThenEqual = value instanceof Float && ((Float)value).floatValue() >= Float.valueOf(operatorNum).floatValue();
        Boolean isDoubleGreaterThenEqual = value instanceof Double && (Double)value >= Double.valueOf(operatorNum);
        Boolean isCollectionGreaterThenEqual = value instanceof Collection && ((Collection)value).size() >= Integer.valueOf(operatorNum);
        if (isStringGreaterThenEqual.booleanValue() || isLongGreaterThenEqual.booleanValue() || isIntegerGreaterThenEqual.booleanValue() || isShortGreaterThenEqual.booleanValue() || isFloatGreaterThenEqual.booleanValue() || isDoubleGreaterThenEqual.booleanValue() || isCollectionGreaterThenEqual.booleanValue()) {
            isGreaterThanEqual = Boolean.TRUE;
        }
        return isGreaterThanEqual;
    }

    private static Boolean isLessThan(Object value, String operatorNum) {
        Boolean isLessThan = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        Boolean isStringLessThen = value instanceof String && ((String)value).length() < Integer.valueOf(operatorNum);
        Boolean isLongLessThen = value instanceof Long && (Long)value < Long.valueOf(operatorNum);
        Boolean isIntegerLessThen = value instanceof Integer && (Integer)value < Integer.valueOf(operatorNum);
        Boolean isShortLessThen = value instanceof Short && (Short)value < Short.valueOf(operatorNum);
        Boolean isFloatLessThen = value instanceof Float && ((Float)value).floatValue() < Float.valueOf(operatorNum).floatValue();
        Boolean isDoubleLessThen = value instanceof Double && (Double)value < Double.valueOf(operatorNum);
        Boolean isCollectionLessThen = value instanceof Collection && ((Collection)value).size() < Integer.valueOf(operatorNum);
        if (isStringLessThen.booleanValue() || isLongLessThen.booleanValue() || isIntegerLessThen.booleanValue() || isShortLessThen.booleanValue() || isFloatLessThen.booleanValue() || isDoubleLessThen.booleanValue() || isCollectionLessThen.booleanValue()) {
            isLessThan = Boolean.TRUE;
        }
        return isLessThan;
    }

    private static Boolean isLessThanEqual(Object value, String operatorNum) {
        Boolean isLessThanEqual = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        Boolean isStringLessThenEqual = value instanceof String && ((String)value).length() <= Integer.valueOf(operatorNum);
        Boolean isLongLessThenEqual = value instanceof Long && (Long)value <= Long.valueOf(operatorNum);
        Boolean isIntegerLessThenEqual = value instanceof Integer && (Integer)value <= Integer.valueOf(operatorNum);
        Boolean isShortLessThenEqual = value instanceof Short && (Short)value <= Short.valueOf(operatorNum);
        Boolean isFloatLessThenEqual = value instanceof Float && ((Float)value).floatValue() <= Float.valueOf(operatorNum).floatValue();
        Boolean isDoubleLessThenEqual = value instanceof Double && (Double)value <= Double.valueOf(operatorNum);
        Boolean isCollectionLessThenEqual = value instanceof Collection && ((Collection)value).size() <= Integer.valueOf(operatorNum);
        if (isStringLessThenEqual.booleanValue() || isLongLessThenEqual.booleanValue() || isIntegerLessThenEqual.booleanValue() || isShortLessThenEqual.booleanValue() || isFloatLessThenEqual.booleanValue() || isDoubleLessThenEqual.booleanValue() || isCollectionLessThenEqual.booleanValue()) {
            isLessThanEqual = Boolean.TRUE;
        }
        return isLessThanEqual;
    }

    private static Boolean isNotEqual(Object value, String operatorNum) {
        Boolean isNotEqual = Boolean.FALSE;
        if (value == null) {
            return Boolean.FALSE;
        }
        Boolean isStringNotEqual = value instanceof String && !value.equals(operatorNum);
        Boolean isLongNotEqual = value instanceof Long && !value.equals(Long.valueOf(operatorNum));
        Boolean isIntegerNotEqual = value instanceof Integer && !value.equals(Integer.valueOf(operatorNum));
        Boolean isShortNotEqual = value instanceof Short && !value.equals(Short.valueOf(operatorNum));
        Boolean isFloatNotEqual = value instanceof Float && !value.equals(Float.valueOf(operatorNum));
        Boolean isDoubleNotEqual = value instanceof Double && !value.equals(Double.valueOf(operatorNum));
        Boolean isCollectionNotEqual = value instanceof Collection && ((Collection)value).size() != Integer.valueOf(operatorNum).intValue();
        if (isStringNotEqual.booleanValue() || isLongNotEqual.booleanValue() || isIntegerNotEqual.booleanValue() || isShortNotEqual.booleanValue() || isFloatNotEqual.booleanValue() || isDoubleNotEqual.booleanValue() || isCollectionNotEqual.booleanValue()) {
            isNotEqual = Boolean.TRUE;
        }
        return isNotEqual;
    }

    private Boolean isCheck(Method method, Object[] arguments) {
        Boolean isCheck = Boolean.TRUE;
        if (!method.isAnnotationPresent(Check.class) || arguments == null) {
            isCheck = Boolean.FALSE;
        }
        return isCheck;
    }

    private Method getMethod(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                LOG.error("" + e);
            }
        }
        return method;
    }

    static enum Operator {
        SPEL("match spel expression", null),
        GREATER_THAN(">", (x$0, x$1) -> CheckParamAspect.access$700(x$0, x$1)),
        GREATER_THAN_EQUAL(">=", (x$0, x$1) -> CheckParamAspect.access$600(x$0, x$1)),
        LESS_THAN("<", (x$0, x$1) -> CheckParamAspect.access$500(x$0, x$1)),
        LESS_THAN_EQUAL("<=", (x$0, x$1) -> CheckParamAspect.access$400(x$0, x$1)),
        NOT_EQUAL("!=", (x$0, x$1) -> CheckParamAspect.access$300(x$0, x$1)),
        NOT_NULL("not null", (x$0, x$1) -> CheckParamAspect.access$200(x$0, x$1));

        private String value;
        private BiFunction<Object, String, Boolean> fun;

        private Operator(String value, BiFunction<Object, String, Boolean> fun) {
            this.value = value;
            this.fun = fun;
        }
    }

    class FieldInfo {
        String field;
        String innerMsg;
        String operator;
        String operatorNum;
        Operator optEnum;

        FieldInfo() {
        }

        public String toString() {
            return "FieldInfo{field='" + this.field + '\'' + ", innerMsg='" + this.innerMsg + '\'' + ", operator='" + this.operator + '\'' + ", operatorNum='" + this.operatorNum + '\'' + ", optEnum=" + (Object)((Object)this.optEnum) + '}';
        }
    }
}

