/*
 * Decompiled with CFR 0.152.
 */
package cn.cimoc.broky.spring.boot.autoconfigure;

import cn.cimoc.broky.core.BrokyException;
import cn.cimoc.broky.handler.BaseHttpMediaTypeNotSupportedExceptionHandler;
import cn.cimoc.broky.handler.BaseHttpMessageNotReadableExceptionHandler;
import cn.cimoc.broky.handler.BaseHttpRequestMethodNotSupportedExceptionHandler;
import cn.cimoc.broky.handler.BaseValidParamExceptionHandler;
import cn.cimoc.broky.handler.DefaultBaseHttpMediaTypeNotSupportedExceptionHandler;
import cn.cimoc.broky.handler.DefaultHttpMessageNotReadableExceptionHandler;
import cn.cimoc.broky.handler.DefaultHttpRequestMethodNotSupportedExceptionHandler;
import cn.cimoc.broky.handler.DefaultValidParamExceptionHandler;
import cn.cimoc.broky.log.BrokyHandledExceptionPool;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="broky", name={"enable"}, havingValue="true", matchIfMissing=true)
public class BrokyHandlerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="broky.log", name={"enable"}, havingValue="true", matchIfMissing=true)
    public BrokyHandledExceptionPool handledExceptionPool() {
        BrokyHandledExceptionPool pool = new BrokyHandledExceptionPool();
        pool.addHandledException(BrokyException.class);
        return pool;
    }

    @Bean
    @ConditionalOnProperty(prefix="broky.handler", name={"http-message-not-readable-handler"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public BaseHttpMessageNotReadableExceptionHandler httpMessageNotReadableExceptionHandler() {
        return new DefaultHttpMessageNotReadableExceptionHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="broky.handler", name={"valid-param-handler"}, havingValue="true")
    @ConditionalOnMissingBean
    public BaseValidParamExceptionHandler validParamExceptionHandler() {
        return new DefaultValidParamExceptionHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="broky.handler", name={"method-not-support-handler"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public BaseHttpRequestMethodNotSupportedExceptionHandler httpRequestMethodNotSupportedExceptionHandler() {
        return new DefaultHttpRequestMethodNotSupportedExceptionHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="broky.handler", name={"media-type-not-support-handler"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public BaseHttpMediaTypeNotSupportedExceptionHandler httpMediaTypeNotSupportedExceptionHandler() {
        return new DefaultBaseHttpMediaTypeNotSupportedExceptionHandler();
    }
}

