/*
 * Decompiled with CFR 0.152.
 */
package cn.cimoc.broky.spring.boot.autoconfigure;

import cn.cimoc.broky.core.BrokyWebConfig;
import cn.cimoc.broky.core.controller.BrokyErrorController;
import cn.cimoc.broky.core.handler.BaseBrokyResponseHandler;
import cn.cimoc.broky.core.handler.BrokyExceptionHandler;
import cn.cimoc.broky.core.handler.BrokyResponseHandler;
import cn.cimoc.broky.core.handler.NoErrorBrokyResponseHandler;
import cn.cimoc.broky.core.interceptor.BrokyResponseInterceptor;
import cn.cimoc.broky.spring.boot.autoconfigure.BrokyHandlerProperties;
import cn.cimoc.broky.spring.boot.autoconfigure.BrokyLogProperties;
import cn.cimoc.broky.spring.boot.autoconfigure.BrokyProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={BrokyProperties.class, BrokyHandlerProperties.class, BrokyLogProperties.class})
@ConditionalOnProperty(prefix="broky", name={"enable"}, havingValue="true", matchIfMissing=true)
public class BrokyAutoConfiguration {
    @Resource
    BrokyProperties brokyProperties;

    @Bean
    public BrokyResponseInterceptor brokyResponseInterceptor() {
        return new BrokyResponseInterceptor(this.brokyProperties.getAnn());
    }

    @Bean
    public BrokyWebConfig brokyWebConfig() {
        return new BrokyWebConfig();
    }

    @Bean
    @ConditionalOnBean(value={BrokyErrorController.class})
    @ConditionalOnMissingBean(value={BaseBrokyResponseHandler.class})
    public BrokyResponseHandler brokyResponseHandler() {
        return new BrokyResponseHandler(this.brokyProperties.getAnn());
    }

    @Bean
    @ConditionalOnMissingBean(value={BrokyErrorController.class, BaseBrokyResponseHandler.class})
    public NoErrorBrokyResponseHandler noErrorBrokyResponseHandler() {
        return new NoErrorBrokyResponseHandler(this.brokyProperties.getAnn());
    }

    @Bean
    public BrokyExceptionHandler brokyExceptionHandler() {
        return new BrokyExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }
}

