/*
 * Decompiled with CFR 0.152.
 */
package cn.cimoc.broky.log;

import cn.cimoc.broky.log.BrokyHandledExceptionPool;
import cn.cimoc.broky.log.BrokyLog;
import cn.cimoc.broky.log.BrokyLogHandler;
import cn.cimoc.broky.log.BrokyLogHandlerConfig;
import cn.cimoc.broky.log.BrokyLogVO;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class DefaultBrokyLogHandler
implements BrokyLogHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultBrokyLogHandler.class);
    private BrokyHandledExceptionPool pool;

    public DefaultBrokyLogHandler(BrokyHandledExceptionPool pool) {
        this.pool = pool;
    }

    @Override
    public void handler(JoinPoint jp, Object keys, Throwable e, BrokyLogHandlerConfig handlerConfig) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        BrokyLogVO logVO = new BrokyLogVO();
        try {
            MethodSignature signature = (MethodSignature)jp.getSignature();
            Method method = signature.getMethod();
            this.copyAnnotationValue(method, logVO);
            logVO.setClassName(jp.getTarget().getClass().getName());
            logVO.setMethodName(method.getName());
            logVO.setUri(request.getRequestURI());
            logVO.setIp(DefaultBrokyLogHandler.getIpAddr(request));
            logVO.setReqTime(this.getNowDate());
            if (null != e) {
                if (this.pool.exist(e.getClass())) {
                    handlerConfig.setExcFullShow(false);
                }
                logVO.setExcName(e.getClass().getName());
                logVO.setExcInfo(this.stackTraceToString(e.getClass().getName(), e.getMessage(), e.getStackTrace(), handlerConfig));
            }
            logVO.setParams(Arrays.toString(jp.getArgs()));
            if (null != keys && Void.class.getName() != keys) {
                StringBuilder result = new StringBuilder(handlerConfig.getObjectMapper().writeValueAsString(keys));
                if (handlerConfig.getResultLength() == 0) {
                    logVO.setReturnValue(result.toString());
                } else {
                    String tempResult = result.substring(0, handlerConfig.getResultLength());
                    logVO.setReturnValue(tempResult);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doLog(e, logVO, handlerConfig);
    }

    protected void copyAnnotationValue(Method method, BrokyLogVO logVO) {
        BrokyLog anno = method.getAnnotation(BrokyLog.class);
        if (anno == null) {
            anno = method.getDeclaringClass().getAnnotation(BrokyLog.class);
        }
        logVO.setModel(anno.module());
        logVO.setOptType(anno.optType());
        logVO.setDescription(anno.description());
    }

    protected void doLog(Throwable e, BrokyLogVO logVO, BrokyLogHandlerConfig handlerConfig) {
        if (null == e) {
            logVO.setExecTime(handlerConfig.getEndAt() - handlerConfig.getStartAt());
            log.info(logVO.toString());
        } else {
            if (this.pool.exist(e.getClass())) {
                logVO.setExecTime(handlerConfig.getEndAt() - handlerConfig.getStartAt());
                log.warn(logVO.toString());
                return;
            }
            logVO.setExecTime(-1L);
            log.error(logVO.toString());
        }
    }

    protected String stackTraceToString(String exceptionName, String exceptionMessage, StackTraceElement[] elements, BrokyLogHandlerConfig handlerConfig) {
        StringBuilder builder = new StringBuilder();
        if (handlerConfig.getExcFullShow().booleanValue()) {
            for (StackTraceElement stet : elements) {
                builder.append(stet).append("\n");
            }
            return exceptionName + ":" + exceptionMessage + "\n\t" + builder;
        }
        return exceptionName + ":" + exceptionMessage;
    }

    protected static String getIpAddr(HttpServletRequest request) {
        String ipAddress = null;
        try {
            String ipAddresses = request.getHeader("X-Forwarded-For");
            if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
                ipAddresses = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
                ipAddresses = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
                ipAddresses = request.getHeader("HTTP_CLIENT_IP");
            }
            if (ipAddresses == null || ipAddresses.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
                ipAddresses = request.getHeader("X-Real-IP");
            }
            if (ipAddresses != null && ipAddresses.length() != 0) {
                ipAddress = ipAddresses.split(",")[0];
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddresses)) {
                ipAddress = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            ipAddress = "";
        }
        return ipAddress;
    }

    protected String getNowDate() {
        Date now = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(now);
    }
}

