/*
 * Decompiled with CFR 0.152.
 */
package cn.cimoc.broky.log;

import cn.cimoc.broky.log.BrokyLog;
import cn.cimoc.broky.log.BrokyLogHandler;
import cn.cimoc.broky.log.BrokyLogHandlerConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class BrokyLogAspect {
    private final BrokyLogHandler logHandler;
    private final ObjectMapper objectMapper;
    private final LogConfig logConfig;

    public BrokyLogAspect(BrokyLogHandler logHandler, ObjectMapper objectMapper, LogConfig logConfig) {
        this.logHandler = logHandler;
        this.objectMapper = objectMapper;
        this.logConfig = logConfig;
    }

    @Pointcut(value="(@within(cn.cimoc.broky.log.BrokyLog) || @annotation(cn.cimoc.broky.log.BrokyLog))")
    public void logCut() {
    }

    @Around(value="logCut()")
    public Object logAround(ProceedingJoinPoint pjp) throws Throwable {
        long startAt = System.currentTimeMillis();
        Object keys = pjp.proceed();
        long endAt = System.currentTimeMillis();
        BrokyLogHandlerConfig handlerConfig = new BrokyLogHandlerConfigBuilder().setStartAt(startAt).setEndAt(endAt).build();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        BrokyLog anno = method.getAnnotation(BrokyLog.class);
        if (anno == null) {
            anno = method.getDeclaringClass().getAnnotation(BrokyLog.class);
        }
        this.setRuntimeFromAnnotation(anno, method, handlerConfig);
        if (this.needLog(handlerConfig)) {
            this.logHandler.handler((JoinPoint)pjp, keys, null, handlerConfig);
        }
        return keys;
    }

    @AfterThrowing(pointcut="logCut()", throwing="e")
    public void doExceptionMyLog(JoinPoint jp, Throwable e) {
        this.logHandler.handler(jp, null, e, new BrokyLogHandlerConfigBuilder().build());
    }

    private void setRuntimeFromAnnotation(BrokyLog anno, Method method, BrokyLogHandlerConfig handlerConfig) {
        if (!"-1".equals(anno.runTime())) {
            try {
                handlerConfig.setRunTime(Long.parseLong(anno.runTime()));
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("\u65b9\u6cd5" + method.getName() + "\u7684\u6ce8\u89e3\u53c2\u6570runtime\u5fc5\u987b\u662f\u6574\u6570");
            }
        }
    }

    protected boolean needLog(BrokyLogHandlerConfig handlerConfig) {
        return handlerConfig.getEndAt() - handlerConfig.getStartAt() >= handlerConfig.getRunTime();
    }

    private class BrokyLogHandlerConfigBuilder {
        private Long startAt = 0L;
        private Long endAt = 0L;

        private BrokyLogHandlerConfigBuilder() {
        }

        public BrokyLogHandlerConfigBuilder setStartAt(Long startAt) {
            this.startAt = startAt;
            return this;
        }

        public BrokyLogHandlerConfigBuilder setEndAt(Long endAt) {
            this.endAt = endAt;
            return this;
        }

        public BrokyLogHandlerConfig build() {
            return new BrokyLogHandlerConfig(BrokyLogAspect.this.objectMapper, BrokyLogAspect.this.logConfig.runTime, BrokyLogAspect.this.logConfig.excFullShow, BrokyLogAspect.this.logConfig.resultLength, this.startAt, this.endAt);
        }
    }

    public static class LogConfigBuilder {
        private Long runTime = null;
        private Boolean excFullShow = null;
        private Integer resultLength = null;

        public LogConfigBuilder setRunTime(Long runTime) {
            if (null == runTime) {
                runTime = 0L;
            }
            this.runTime = runTime;
            return this;
        }

        public LogConfigBuilder setExcFullShow(Boolean excFullShow) {
            if (null == excFullShow) {
                excFullShow = true;
            }
            this.excFullShow = excFullShow;
            return this;
        }

        public LogConfigBuilder setResultLength(Integer resultLength) {
            if (null == resultLength) {
                resultLength = 0;
            }
            this.resultLength = resultLength;
            return this;
        }

        public LogConfig build() {
            return new LogConfig(this.runTime, this.excFullShow, this.resultLength);
        }
    }

    public static class LogConfig {
        private final Long runTime;
        private final Boolean excFullShow;
        private final Integer resultLength;

        private LogConfig(Long runTime, Boolean excFullShow, Integer resultLength) {
            this.runTime = runTime;
            this.excFullShow = excFullShow;
            this.resultLength = resultLength;
        }

        public Long getRunTime() {
            return this.runTime;
        }

        public Boolean getExcFullShow() {
            return this.excFullShow;
        }

        public Integer getResultLength() {
            return this.resultLength;
        }
    }
}

