/*
 * Decompiled with CFR 0.152.
 */
package cn.cimoc.broky.handler;

import cn.cimoc.broky.core.BrokyResult;
import cn.cimoc.broky.core.BrokyUtils;
import cn.cimoc.broky.handler.BaseHttpMediaTypeNotSupportedExceptionHandler;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class DefaultBaseHttpMediaTypeNotSupportedExceptionHandler
extends BaseHttpMediaTypeNotSupportedExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultBaseHttpMediaTypeNotSupportedExceptionHandler.class);

    @Override
    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    public BrokyResult handle(HttpMediaTypeNotSupportedException e) {
        log.warn(e.getMessage());
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator iterator = e.getSupportedMediaTypes().iterator();
        while (iterator.hasNext()) {
            MediaType next = (MediaType)iterator.next();
            builder.append(next.getType()).append('/').append(next.getSubtype());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
        if (e.getContentType() == null) {
            return BrokyUtils.ajaxReturn((Integer)415, (String)"\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b");
        }
        return BrokyUtils.ajaxReturn((Integer)415, (String)("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b:" + e.getContentType().getType() + "/" + e.getContentType().getSubtype() + ", \u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b:" + builder));
    }
}

