/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wx.network;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.base.constants.BaseConstants;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.core.util.RedisUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.common.WeiXinLanguageEnum;
import cn.chiship.sdk.third.wx.core.common.WxPubCommonConstants;
import cn.chiship.sdk.third.wx.core.common.WxPubMaterialTypeEnum;
import cn.chiship.sdk.third.wx.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wx.core.entity.pub.Button;
import cn.chiship.sdk.third.wx.core.entity.pub.ClickButton;
import cn.chiship.sdk.third.wx.core.entity.pub.Menu;
import cn.chiship.sdk.third.wx.core.entity.pub.MiniprogramButton;
import cn.chiship.sdk.third.wx.core.entity.pub.ViewButton;
import cn.chiship.sdk.third.wx.core.entity.pub.message.MessageTemplateSend;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxPubServicesUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(WxPubServicesUtil.class);
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    private static final String TAG_ID = "tagid";
    private static final String OPEN_ID = "openid";
    private static final String APP_ID = "appid";
    private static final String ACCESS_TOKEN = "access_token";
    private WeiXinConfig weiXinConfig;
    private String accessToken = null;
    private static WxPubServicesUtil instance;

    private WxPubServicesUtil() {
    }

    public static synchronized WxPubServicesUtil getInstance() {
        if (instance == null) {
            instance = new WxPubServicesUtil();
        }
        return instance;
    }

    public WxPubServicesUtil config() {
        this.weiXinConfig = new WeiXinConfig(this.commonConfigProperties.getValue("third.wxPub.appKey"), this.commonConfigProperties.getValue("third.wxPub.appSecret"));
        return this;
    }

    public WxPubServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    public WxPubServicesUtil token() {
        BaseResult baseResult = this.getToken();
        if (!baseResult.isSuccess()) {
            throw new BusinessException(JSON.toJSONString((Object)baseResult.getData()));
        }
        this.accessToken = baseResult.getData().toString();
        return this;
    }

    public BaseResult getToken() {
        String key = "THIRD:WX_PUB_ACCESS_TOKEN:" + this.weiXinConfig.getAppKey();
        String token = RedisUtil.get((String)key);
        if (!StringUtil.isNullOrEmpty((String)token)) {
            return BaseResult.ok((Object)token);
        }
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("grant_type", "client_credential");
        query.put(APP_ID, this.weiXinConfig.getAppKey());
        query.put("secret", this.weiXinConfig.getAppSecret());
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/token", WxPubCommonConstants.commonHeaders(), query);
            BaseResult result = WxPubCommonConstants.analysisPubHttpResponse(baseResult);
            if (!result.isSuccess()) {
                return result;
            }
            JSONObject dataJson = (JSONObject)result.getData();
            token = dataJson.getString(ACCESS_TOKEN);
            String expiresIn = dataJson.getString("expires_in");
            result.setData((Object)token);
            RedisUtil.set((String)key, (String)token, (int)Integer.valueOf(expiresIn));
            return result;
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult getUserInfo(String openId) {
        return this.getUserInfo(openId, WeiXinLanguageEnum.WX_ZH_CN);
    }

    public BaseResult getUserInfo(String openId, WeiXinLanguageEnum weiXinLanguageEnum) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        query.put(OPEN_ID, openId);
        query.put("lang", weiXinLanguageEnum.getLang());
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/info", WxPubCommonConstants.commonHeaders(), query);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult updateUserRemark(String openId, String remark) {
        byte[] bytes = remark.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 30) {
            bytes = Arrays.copyOfRange(bytes, 0, 30);
            remark = new String(bytes);
        }
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(7);
        body.put(OPEN_ID, openId);
        body.put("remark", remark);
        try {
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/info/updateremark", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult syncUser() {
        return this.syncUser(null);
    }

    public BaseResult syncUser(String nextOpenId) {
        try {
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            query.put("next_openid", nextOpenId);
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/get", WxPubCommonConstants.commonHeaders(), query);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult createMenu(Menu menu) {
        if (menu.getButton().size() > 3) {
            return BaseResult.error((Object)"\u4e00\u7ea7\u6309\u94ae\u4e2a\u6570\u6700\u591a3\u4e2a");
        }
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap buttonMap = new HashMap(7);
        ArrayList firstButton = new ArrayList();
        for (Button button : menu.getButton()) {
            HashMap<String, String> menuMap = new HashMap<String, String>(2);
            menuMap.put("name", button.getName());
            menuMap.put("type", button.getType());
            if ("click".equals(button.getType())) {
                menuMap.put("key", ((ClickButton)button).getKey());
            } else if ("view".equals(button.getType())) {
                menuMap.put("url", ((ViewButton)button).getUrl());
            } else if ("miniprogram".equals(button.getType())) {
                menuMap.put("url", ((MiniprogramButton)button).getUrl());
                menuMap.put(APP_ID, ((MiniprogramButton)button).getAppid());
                menuMap.put("pagepath", ((MiniprogramButton)button).getPagepath());
            }
            if (button.getSub_button() == null) {
                firstButton.add(menuMap);
            } else {
                HashMap<String, Object> secondMap = new HashMap<String, Object>(7);
                secondMap.put("name", button.getName());
                ArrayList secondButton = new ArrayList();
                for (Button subButton : button.getSub_button()) {
                    HashMap<String, String> second = new HashMap<String, String>(7);
                    second.put("type", subButton.getType());
                    second.put("name", subButton.getName());
                    if ("click".equals(subButton.getType())) {
                        second.put("key", ((ClickButton)subButton).getKey());
                        secondButton.add(second);
                        continue;
                    }
                    if ("view".equals(subButton.getType())) {
                        second.put("url", ((ViewButton)subButton).getUrl());
                        secondButton.add(second);
                        continue;
                    }
                    if (!"miniprogram".equals(subButton.getType())) continue;
                    second.put("url", ((MiniprogramButton)subButton).getUrl());
                    second.put(APP_ID, ((MiniprogramButton)subButton).getAppid());
                    second.put("pagepath", ((MiniprogramButton)subButton).getPagepath());
                    secondButton.add(second);
                }
                secondMap.put("sub_button", secondButton);
                firstButton.add(secondMap);
            }
            buttonMap.put("button", firstButton);
        }
        try {
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/menu/create", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(buttonMap));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult getTags() {
        try {
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/tags/get", WxPubCommonConstants.commonHeaders(), query);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult createTag(String tagName) {
        try {
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap body = new HashMap(7);
            HashMap<String, String> tag = new HashMap<String, String>(7);
            tag.put("name", tagName);
            body.put("tag", tag);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/tags/create", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult updateTag(String tagId, String tagName) {
        try {
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap body = new HashMap(7);
            HashMap<String, String> tag = new HashMap<String, String>(7);
            tag.put("name", tagName);
            tag.put("id", tagId);
            body.put("tag", tag);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/tags/update", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult deleteTag(String tagId) {
        try {
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap body = new HashMap(7);
            HashMap<String, String> tag = new HashMap<String, String>(7);
            tag.put("id", tagId);
            body.put("tag", tag);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/tags/delete", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult tagGetUser(String tagId) {
        return this.tagGetUser(tagId, null);
    }

    public BaseResult tagGetUser(String tagId, String nextOpenId) {
        try {
            if (StringUtil.isNull((Object)nextOpenId)) {
                nextOpenId = "";
            }
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap<String, String> body = new HashMap<String, String>(7);
            body.put(TAG_ID, tagId);
            body.put("next_openid", nextOpenId);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/user/tag/get", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult memberBatchTag(String openId, String tagId) {
        ArrayList<String> openIds = new ArrayList<String>();
        openIds.add(openId);
        return this.memberBatchTag(openIds, tagId);
    }

    public BaseResult memberBatchTag(List<String> openIds, String tagId) {
        try {
            if (openIds.isEmpty()) {
                return BaseResult.error((Object)"\u7528\u6237\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap<String, Object> body = new HashMap<String, Object>(7);
            body.put(TAG_ID, tagId);
            body.put("openid_list", openIds);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/tags/members/batchtagging", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult memberBatchUnTag(String openId, String tagId) {
        ArrayList<String> openIds = new ArrayList<String>();
        openIds.add(openId);
        return this.memberBatchUnTag(openIds, tagId);
    }

    public BaseResult memberBatchUnTag(List<String> openIds, String tagId) {
        try {
            if (openIds.isEmpty()) {
                return BaseResult.error((Object)"\u7528\u6237\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap<String, Object> body = new HashMap<String, Object>(7);
            body.put(TAG_ID, tagId);
            body.put("openid_list", openIds);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/tags/members/batchuntagging", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult getQrCodeByForever(String sceneStr) {
        String params = "{\"action_name\": \"QR_LIMIT_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + sceneStr + "\"}}}";
        return this.getQrCode(params);
    }

    public BaseResult getQrCodeByTemporary(Integer expireSeconds, String sceneStr) {
        if (expireSeconds > 2592000) {
            expireSeconds = 2592000;
        }
        String params = "{\"expire_seconds\": " + expireSeconds + ", \"action_name\": \"QR_STR_SCENE\", \"action_info\": {\"scene\": {\"scene_str\": \"" + sceneStr + "\"}}}";
        return this.getQrCode(params);
    }

    private BaseResult getQrCode(String params) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        try {
            query.put(ACCESS_TOKEN, this.getAccessToken());
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/qrcode/create", WxPubCommonConstants.commonHeaders(), query, (String)params);
            BaseResult ticketResult = WxPubCommonConstants.analysisPubHttpResponse(baseResult);
            if (!ticketResult.isSuccess()) {
                ticketResult.setData((Object)("\u83b7\u53d6Ticket\u62a5\u9519\uff0c" + ticketResult.getData()));
                return ticketResult;
            }
            String ticket = JSON.parseObject((String)JSON.toJSONString((Object)ticketResult.getData())).getString("ticket");
            String qrCodeUrl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + ticket;
            return BaseResult.ok((Object)ImageUtil.getImgByteByUrl((String)qrCodeUrl));
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u4e8c\u7ef4\u7801", (Throwable)e);
            return null;
        }
    }

    public BaseResult getAllPrivateMessageTemplate() {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/template/get_all_private_template", WxPubCommonConstants.commonHeaders(), query);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult deleteTemplate(String templateId) {
        try {
            HashMap<String, String> query = new HashMap<String, String>(7);
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap<String, String> body = new HashMap<String, String>(7);
            body.put("template_id", templateId);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/template/del_private_template", WxPubCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult messageTemplateSend(MessageTemplateSend messageTemplateSend) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        try {
            String body = JSON.toJSONString((Object)messageTemplateSend);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/message/template/send", WxPubCommonConstants.commonHeaders(), query, (String)body);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public String getConnectOauth2Url(String redirectUri, String params, Boolean isSilence) {
        try {
            String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect".replace("APPID", this.weiXinConfig.getAppKey()).replace("REDIRECT_URI", URLEncoder.encode(redirectUri, "UTF-8")).replace("SCOPE", Boolean.TRUE.equals(isSilence) ? "snsapi_base" : "snsapi_userinfo");
            if (params != null) {
                url = url.replace("STATE", params);
            }
            return url;
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u5f97\u6388\u6743\u8ba4\u8bc1\u8fde\u63a5\u53d1\u751f\u9519\u8bef:" + e.getLocalizedMessage());
        }
    }

    public BaseResult oauth2AccessToken(String code) {
        try {
            String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code".replace("APPID", this.weiXinConfig.getAppKey()).replace("SECRET", this.weiXinConfig.getAppSecret()).replace("CODE", code);
            BaseResult baseResult = HttpUtils.doGet((String)url, (String)"", WxPubCommonConstants.commonHeaders(), null);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult getAccessUserInfo(String token, String openId) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put(ACCESS_TOKEN, token);
        query.put(OPEN_ID, openId);
        query.put("lang", "zh_CN");
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"sns/userinfo", WxPubCommonConstants.commonHeaders(), query);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult addMaterial(File file, WxPubMaterialTypeEnum wxPubMaterialTypeEnum) {
        return this.addMaterial(file, null, null, wxPubMaterialTypeEnum);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseResult addMaterial(File file, String title, String desc, WxPubMaterialTypeEnum wxPubMaterialTypeEnum) {
        if (!file.exists()) throw new BusinessException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        if (!file.isFile()) {
            throw new BusinessException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            BaseResult baseResult = this.uploadMedia(fileInputStream, file.getName(), title, desc, wxPubMaterialTypeEnum.getType());
            return baseResult;
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResult uploadMedia(InputStream inputStream, String fileName, String title, String introduction, String fileType) throws IOException {
        String urlString = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" + this.getAccessToken() + "&type=" + fileType;
        Object result = null;
        URL url = new URL(urlString);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        String boundary = "----------" + System.currentTimeMillis();
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        StringBuilder sb = new StringBuilder();
        sb.append("--");
        sb.append(boundary);
        sb.append("\r\n");
        sb.append("Content-Disposition: form-data;name=\"media\"; filename=\"" + fileName + "\"\r\n");
        sb.append("Content-Disposition: form-data;name=\"media\"; filename=\"" + fileName + "\"\r\n");
        sb.append("Content-Type:application/octet-stream\r\n\r\n");
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        if (WxPubMaterialTypeEnum.MATERIAL_TYPE_VIDEO.getType().equals(fileType)) {
            ((OutputStream)out).write(("--" + boundary + "\r\n").getBytes());
            ((OutputStream)out).write("Content-Disposition: form-data; name=\"description\";\r\n\r\n".getBytes());
            ((OutputStream)out).write(String.format("{\"title\":\"%s\", \"introduction\":\"%s\"}", title, introduction).getBytes());
            ((OutputStream)out).write(("\r\n--" + boundary + "--\r\n\r\n").getBytes());
        }
        ((OutputStream)out).write(sb.toString().getBytes(StandardCharsets.UTF_8));
        DataInputStream din = new DataInputStream(inputStream);
        int bytes = 0;
        byte[] buffer = new byte[1024];
        while ((bytes = din.read(buffer)) != -1) {
            ((OutputStream)out).write(buffer, 0, bytes);
        }
        din.close();
        byte[] foot = ("\r\n--" + boundary + "--\r\n").getBytes(StandardCharsets.UTF_8);
        ((OutputStream)out).write(foot);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        if (BaseConstants.STATUS_OK.intValue() == conn.getResponseCode()) {
            try (BufferedReader reader = null;){
                String lineString;
                StringBuilder builder = new StringBuilder();
                reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                while ((lineString = reader.readLine()) != null) {
                    builder.append(lineString);
                }
                if (StringUtil.isNull(result)) {
                    BaseResult baseResult = WxPubCommonConstants.analysisPubHttpResponse(BaseResult.ok((Object)builder.toString()));
                    return baseResult;
                }
                BaseResult baseResult = BaseResult.error((Object)"\u4e0a\u4f20\u7d20\u6750\u51fa\u73b0\u9519\u8bef");
                return baseResult;
            }
        }
        return BaseResult.error((Object)"\u4e0a\u4f20\u7d20\u6750\u51fa\u73b0\u9519\u8bef");
    }

    public BaseResult getMaterial(String mediaId) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        try {
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap<String, String> body = new HashMap<String, String>(7);
            body.put("media_id", mediaId);
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/material/get_material", WxPubCommonConstants.commonHeaders(), query, body);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult getBatchMaterial(Integer pageIndex, WxPubMaterialTypeEnum wxPubMaterialTypeEnum) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        try {
            query.put(ACCESS_TOKEN, this.getAccessToken());
            HashMap<String, String> body = new HashMap<String, String>(7);
            body.put("type", wxPubMaterialTypeEnum.getType());
            body.put("offset", String.valueOf((pageIndex - 1) * 20));
            body.put("count", String.valueOf(20));
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/material/batchget_material", WxPubCommonConstants.commonHeaders(), query, body);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public String getAccessToken() {
        if (StringUtil.isNullOrEmpty((String)this.accessToken)) {
            throw new BusinessException("token\u4e3a\u7a7a\uff01\u8bf7\u94fe\u5f0f\u8c03\u7528\u5982\u4e0b\u65b9\u6cd5\uff1aWxPubServicesUtil.getInstance().config().token()\u83b7\u5f97Token");
        }
        return this.accessToken;
    }
}

