/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wx.network;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.core.util.RedisUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.wx.core.common.MiniProgramVersion;
import cn.chiship.sdk.third.wx.core.common.WxMiniProgramCommonConstants;
import cn.chiship.sdk.third.wx.core.common.WxPubCommonConstants;
import cn.chiship.sdk.third.wx.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wx.core.entity.subscribe.Template;
import cn.chiship.sdk.third.wx.core.util.WxBizDataCrypt;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMiniProgramServicesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WxMiniProgramServicesUtil.class);
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    private static final String ACCESS_TOKEN = "access_token";
    private WeiXinConfig weiXinConfig;
    private static WxMiniProgramServicesUtil instance;
    private String accessToken = null;

    private WxMiniProgramServicesUtil() {
    }

    public static synchronized WxMiniProgramServicesUtil getInstance() {
        if (instance == null) {
            instance = new WxMiniProgramServicesUtil();
        }
        return instance;
    }

    public WxMiniProgramServicesUtil config() {
        this.weiXinConfig = new WeiXinConfig(this.commonConfigProperties.getValue("third.wxMini.appKey"), this.commonConfigProperties.getValue("third.wxMini.appSecret"));
        return this;
    }

    public WxMiniProgramServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    public WxMiniProgramServicesUtil token() {
        BaseResult BaseResult2 = this.getToken();
        if (!BaseResult2.isSuccess()) {
            throw new BusinessException(JSON.toJSONString((Object)BaseResult2.getData()));
        }
        this.accessToken = BaseResult2.getData().toString();
        return this;
    }

    public BaseResult getToken() {
        String key = "THIRD:WX_MINI_PROGRAM_ACCESS_TOKEN:" + this.weiXinConfig.getAppKey();
        String token = RedisUtil.get((String)key);
        if (!StringUtil.isNullOrEmpty((String)token)) {
            return BaseResult.ok((Object)token);
        }
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("grant_type", "client_credential");
        query.put("appid", this.weiXinConfig.getAppKey());
        query.put("secret", this.weiXinConfig.getAppSecret());
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"cgi-bin/token", WxMiniProgramCommonConstants.commonHeaders(), query);
            BaseResult result = WxMiniProgramCommonConstants.analysisPubHttpResponse(baseResult);
            if (!result.isSuccess()) {
                return result;
            }
            JSONObject dataJson = (JSONObject)result.getData();
            String accessToken = dataJson.getString(ACCESS_TOKEN);
            String expiresIn = dataJson.getString("expires_in");
            result.setData((Object)accessToken);
            RedisUtil.set((String)key, (String)accessToken, (int)Integer.valueOf(expiresIn));
            return result;
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    private BaseResult getQrCode1(String page, String scene, MiniProgramVersion miniProgramVersion) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(7);
        body.put("scene", scene);
        body.put("page", page);
        body.put("env_version", miniProgramVersion.getVersion());
        try {
            BaseResult responseTicketResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"wxa/getwxacodeunlimit", WxMiniProgramCommonConstants.commonHeaders(), query, (String)JSON.toJSONString(body));
            System.out.println(responseTicketResult);
            return BaseResult.ok(null);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public BaseResult code2Session(String code) {
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("grant_type", "authorization_code");
        query.put("appid", this.weiXinConfig.getAppKey());
        query.put("secret", this.weiXinConfig.getAppSecret());
        query.put("js_code", code);
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://api.weixin.qq.com/", (String)"sns/jscode2session", WxPubCommonConstants.commonHeaders(), query);
            return WxMiniProgramCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public BaseResult decryptingOpenData(String encryptedData, String iv, String sessionKey) {
        WxBizDataCrypt wxBizDataCrypt = new WxBizDataCrypt(encryptedData, sessionKey, iv);
        return wxBizDataCrypt.decryptData();
    }

    public BaseResult messageSubscribeSend(Template template) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        BaseResult BaseResult2 = null;
        if (!BaseResult2.isSuccess()) {
            return BaseResult2;
        }
        String token = BaseResult2.getData().toString();
        query.put(ACCESS_TOKEN, token);
        try {
            String body = template.toJSON();
            BaseResult baseResult = HttpUtils.doPost((String)"https://api.weixin.qq.com/", (String)"cgi-bin/message/subscribe/send", WxPubCommonConstants.commonHeaders(), query, (String)body);
            return WxPubCommonConstants.analysisPubHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public String getAccessToken() {
        if (StringUtil.isNullOrEmpty((String)this.accessToken)) {
            throw new BusinessException("token\u4e3a\u7a7a\uff01\u8bf7\u94fe\u5f0f\u8c03\u7528\u5982\u4e0b\u65b9\u6cd5\uff1aWxMinMiniProgramServicesUtil.getInstance().config().token()\u83b7\u5f97Token");
        }
        return this.accessToken;
    }
}

