/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wx.core.util;

import cn.chiship.sdk.third.wx.core.entity.pub.Image;
import cn.chiship.sdk.third.wx.core.entity.pub.ImageMessage;
import cn.chiship.sdk.third.wx.core.entity.pub.ImageTextMessage;
import cn.chiship.sdk.third.wx.core.entity.pub.Item;
import cn.chiship.sdk.third.wx.core.entity.pub.TextMessage;
import cn.chiship.sdk.third.wx.core.entity.pub.message.ImageText;
import cn.chiship.sdk.third.wx.core.entity.pub.message.ImageTextNews;
import cn.chiship.sdk.third.wx.core.entity.pub.message.ImageTextNewsArticles;
import cn.chiship.sdk.third.wx.core.entity.pub.message.Text;
import cn.chiship.sdk.third.wx.core.entity.pub.message.TextNews;
import com.alibaba.fastjson.JSON;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WxPubMessageToXml {
    private static final Integer TEN = 10;
    private static final Integer ELEVEN = 11;

    private WxPubMessageToXml() {
    }

    public static Map<String, String> xmlToMap(InputStream ins) throws IOException, DocumentException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        SAXReader reader = new SAXReader();
        Document document = reader.read(ins);
        Element root = document.getRootElement();
        List elements = root.elements();
        for (Element element : elements) {
            map.put(element.getName(), element.getText().trim());
        }
        ins.close();
        return map;
    }

    public static String imageMessageToXML(ImageMessage imageMessage) {
        XStream xStream = new XStream();
        xStream.alias("xml", imageMessage.getClass());
        return xStream.toXML((Object)imageMessage);
    }

    public static String imageTextMessageToXML(ImageTextMessage imageTextMessage, Item item) {
        XStream xStream = new XStream();
        xStream.alias("xml", imageTextMessage.getClass());
        xStream.alias("item", item.getClass());
        return xStream.toXML((Object)imageTextMessage);
    }

    public static String initTextMessage(String fromUserName, String toUserName, String content) {
        TextMessage wxTextMessage = new TextMessage(fromUserName, toUserName, content);
        return wxTextMessage.toXml();
    }

    public static String initImageMessage(String fromUserName, String toUserName, String mediaId) {
        ImageMessage imageMessage = new ImageMessage();
        imageMessage.setFromUserName(toUserName);
        imageMessage.setToUserName(fromUserName);
        imageMessage.setCreateTime(System.currentTimeMillis());
        imageMessage.setMsgType("image");
        Image image = new Image();
        image.setMediaId(mediaId);
        imageMessage.setImage(image);
        return WxPubMessageToXml.imageMessageToXML(imageMessage);
    }

    public static String initImageTextMessage(String fromUserName, String toUserName, List<Item> item, Integer count) {
        ImageTextMessage imageTextMessage = new ImageTextMessage();
        imageTextMessage.setFromUserName(toUserName);
        imageTextMessage.setToUserName(fromUserName);
        imageTextMessage.setCreateTime(System.currentTimeMillis());
        imageTextMessage.setArticleCount(count);
        imageTextMessage.setMsgType("news");
        if (count < ELEVEN) {
            imageTextMessage.setArticles(item);
            return WxPubMessageToXml.imageTextMessageToXML(imageTextMessage, new Item());
        }
        ArrayList<Item> item_1 = new ArrayList<Item>();
        for (int i = 0; i < TEN; ++i) {
            item_1.add(item.get(i));
        }
        imageTextMessage.setArticles(item_1);
        return WxPubMessageToXml.imageTextMessageToXML(imageTextMessage, new Item());
    }

    public static String initImageText(String openId, List<ImageTextNewsArticles> articles) {
        ImageTextNews imageTextNews = new ImageTextNews();
        imageTextNews.setArticles(articles);
        ImageText imageText = new ImageText();
        imageText.setTouser(openId);
        imageText.setMsgtype("news");
        imageText.setNews(imageTextNews);
        return JSON.toJSONString((Object)imageText);
    }

    public static String initText(String openId, String content) {
        Text text = new Text();
        text.setContent(content);
        TextNews textNews = new TextNews();
        textNews.setTouser(openId);
        textNews.setMsgtype("text");
        textNews.setText(text);
        return JSON.toJSONString((Object)textNews);
    }
}

