/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.wx.core.util;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WxBizDataCrypt {
    private static String keyAlgorithm = "AES";
    private static boolean initialized = false;
    private Base64.Decoder decoder = Base64.getDecoder();
    private String originalContent;
    private String encryptKey;
    private String iv;

    public WxBizDataCrypt(String originalContent, String encryptKey, String iv) {
        this.originalContent = originalContent;
        this.encryptKey = encryptKey;
        this.iv = iv;
    }

    public BaseResult decryptData() {
        WxBizDataCrypt.initialize();
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            SecretKeySpec sKeySpec = new SecretKeySpec(this.decoder.decode(this.encryptKey), keyAlgorithm);
            cipher.init(2, (Key)sKeySpec, WxBizDataCrypt.generateIv(this.decoder.decode(this.iv)));
            byte[] data = cipher.doFinal(this.decoder.decode(this.originalContent));
            String dataResult = new String(data, StandardCharsets.UTF_8);
            JSONObject json = JSON.parseObject((String)dataResult);
            return BaseResult.ok((Object)json);
        }
        catch (Exception e) {
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        initialized = true;
    }

    private static AlgorithmParameters generateIv(byte[] iv) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        AlgorithmParameters params = AlgorithmParameters.getInstance(keyAlgorithm);
        params.init(new IvParameterSpec(iv));
        return params;
    }
}

