/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.storage.impl;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.model.tencent.TencentCosConfigModel;
import cn.chiship.sdk.third.storage.FileStorageService;
import com.alibaba.fastjson.JSONObject;
import com.qcloud.cos.COS;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.Upload;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentCosServiceImpl
implements FileStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TencentCosServiceImpl.class);
    private static final String S1 = "TencentOssServiceImpl\u53d1\u751f\u9519\u8bef:{}";
    private TencentCosConfigModel tencentOssConfigModel;

    public TencentCosServiceImpl(TencentCosConfigModel tencentOssConfigModel) {
        this.tencentOssConfigModel = tencentOssConfigModel;
    }

    public TencentCosServiceImpl() {
        this.tencentOssConfigModel = new TencentCosConfigModel();
    }

    @Override
    public BaseResult upload(InputStream inputStream, String fileName) {
        return this.upload(inputStream, null, fileName);
    }

    @Override
    public BaseResult upload(InputStream inputStream, String catalog, String fileName) {
        TransferManager transferManager = this.createTransferManager();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        String objectKey = !StringUtil.isNullOrEmpty((String)catalog) ? this.tencentOssConfigModel.getRoot() + "/" + catalog + "/" + fileName : this.tencentOssConfigModel.getRoot() + "/" + fileName;
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.tencentOssConfigModel.getBuckName(), objectKey, inputStream, objectMetadata);
        putObjectRequest.setStorageClass(StorageClass.Standard_IA);
        try {
            Upload upload = transferManager.upload(putObjectRequest);
            UploadResult uploadResult = upload.waitForUploadResult();
            String fileUrl = String.format("http://%s.cos.%s.myqcloud.com/%s", uploadResult.getBucketName(), this.tencentOssConfigModel.getOssEndPort(), uploadResult.getKey());
            this.shutdownTransferManager(transferManager);
            LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            return BaseResult.ok((Object)fileUrl);
        }
        catch (CosServiceException e) {
            LOGGER.error(S1, (Object)e.getErrorMessage());
            return BaseResult.error((Object)e.getErrorMessage());
        }
        catch (CosClientException e) {
            LOGGER.error(S1, (Object)e.getMessage());
            return BaseResult.error((Object)e.getMessage());
        }
        catch (InterruptedException e) {
            return BaseResult.error((Object)e.getLocalizedMessage());
        }
    }

    @Override
    public BaseResult uploadBase64(String base64, String fileName) {
        return this.uploadBase64(base64, null, fileName);
    }

    @Override
    public BaseResult uploadBase64(String base64, String catalog, String fileName) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] bytes = decoder.decode(base64);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return BaseResult.ok((Object)this.upload(inputStream, catalog, fileName));
    }

    @Override
    public BaseResult removeFile(String fileName) {
        return this.removeFiles(Arrays.asList(fileName));
    }

    @Override
    public BaseResult removeFiles(List<String> fileNames) {
        try {
            COSClient cosClient = this.createCOSClient();
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.tencentOssConfigModel.getBuckName());
            ArrayList<DeleteObjectsRequest.KeyVersion> keyList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
            String fileUrlPrefix = String.format("http://%s.cos.%s.myqcloud.com/%s/", this.tencentOssConfigModel.getBuckName(), this.tencentOssConfigModel.getOssEndPort(), this.tencentOssConfigModel.getRoot());
            for (String fileName : fileNames) {
                String fileKey = fileName.replace(fileUrlPrefix, "");
                fileKey = this.tencentOssConfigModel.getRoot() + "/" + fileKey;
                keyList.add(new DeleteObjectsRequest.KeyVersion(fileKey));
            }
            deleteObjectsRequest.setKeys(keyList);
            DeleteObjectsResult deleteObjectsResult = cosClient.deleteObjects(deleteObjectsRequest);
            deleteObjectsResult.getDeletedObjects();
            LOGGER.info("\u6587\u4ef6\u5220\u9664\u6210\u529f");
            return BaseResult.ok();
        }
        catch (MultiObjectDeleteException mde) {
            List deleteErrors = mde.getErrors();
            System.err.println(JSONObject.toJSONString((Object)deleteErrors));
            LOGGER.error(S1, (Object)JSONObject.toJSONString((Object)deleteErrors));
            return BaseResult.error((Object)"\u90e8\u5206\u5220\u9664\u6210\u529f\u90e8\u5206\u5931\u8d25");
        }
        catch (CosServiceException e) {
            LOGGER.error(S1, (Object)e.getErrorMessage());
            return BaseResult.error((Object)e.getMessage());
        }
        catch (CosClientException e) {
            LOGGER.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return BaseResult.error((Object)e.getMessage());
        }
    }

    COSClient createCOSClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.tencentOssConfigModel.getAppKey(), this.tencentOssConfigModel.getAppSecret());
        Region region = new Region(this.tencentOssConfigModel.getOssEndPort());
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        COSClient cosClient = new COSClient((COSCredentials)cred, clientConfig);
        return cosClient;
    }

    TransferManager createTransferManager() {
        COSClient cosClient = this.createCOSClient();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(2, 5, 3L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(3), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        TransferManager transferManager = new TransferManager((COS)cosClient, (ExecutorService)threadPool);
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        transferManagerConfiguration.setMultipartUploadThreshold(0x500000L);
        transferManagerConfiguration.setMinimumUploadPartSize(0x100000L);
        transferManager.setConfiguration(transferManagerConfiguration);
        return transferManager;
    }

    void shutdownTransferManager(TransferManager transferManager) {
        transferManager.shutdownNow(true);
    }
}

