/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.storage.impl;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.third.core.model.baidu.BaiDuBosConfigModel;
import cn.chiship.sdk.third.storage.FileStorageService;
import com.baidubce.BceClientException;
import com.baidubce.BceServiceException;
import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.PutObjectResponse;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiDuOssServiceImpl
implements FileStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiDuOssServiceImpl.class);
    private BaiDuBosConfigModel baiDuOssConfigModel;

    public BaiDuOssServiceImpl(BaiDuBosConfigModel baiDuOssConfigModel) {
        this.baiDuOssConfigModel = baiDuOssConfigModel;
    }

    public BaiDuOssServiceImpl() {
        this.baiDuOssConfigModel = new BaiDuBosConfigModel();
    }

    @Override
    public BaseResult upload(InputStream inputStream, String fileName) {
        return this.upload(inputStream, null, fileName);
    }

    @Override
    public BaseResult upload(InputStream inputStream, String catalog, String fileName) {
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(this.baiDuOssConfigModel.getAppKey(), this.baiDuOssConfigModel.getAppSecret()));
        config.setEndpoint(this.baiDuOssConfigModel.getOssEndPort());
        BosClient client = new BosClient(config);
        try {
            PutObjectResponse putObjectResponseFromInputStream = client.putObject("buck", "inputStream-objectKey", inputStream);
            LOGGER.info(111 + putObjectResponseFromInputStream.getETag());
            client.shutdown();
            return BaseResult.ok();
        }
        catch (BceServiceException bce) {
            LOGGER.info("Error ErrorCode: " + bce.getErrorCode());
            LOGGER.info("Error RequestId: " + bce.getRequestId());
            LOGGER.info("Error StatusCode: " + bce.getStatusCode());
            LOGGER.info("Error ErrorType: " + bce.getErrorType());
            LOGGER.info("Error Message: " + bce.getMessage());
            return BaseResult.error((Object)bce.getMessage());
        }
        catch (BceClientException bce) {
            LOGGER.info(bce.getMessage());
            return BaseResult.error((Object)bce.getMessage());
        }
        catch (Exception e) {
            return BaseResult.error((Object)e.getLocalizedMessage());
        }
    }

    @Override
    public BaseResult uploadBase64(String base64, String fileName) {
        return null;
    }

    @Override
    public BaseResult uploadBase64(String base64, String catalog, String fileName) {
        return null;
    }

    @Override
    public BaseResult removeFile(String fileName) {
        return null;
    }

    @Override
    public BaseResult removeFiles(List<String> fileNames) {
        return null;
    }
}

