/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.storage.impl;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.model.ali.AliOssConfigModel;
import cn.chiship.sdk.third.storage.FileStorageService;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOssServiceImpl
implements FileStorageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliOssServiceImpl.class);
    private static final String S1 = "AliOssServiceImpl\u53d1\u751f\u9519\u8bef:{}";
    private AliOssConfigModel aliOssConfigModel;

    public AliOssServiceImpl(AliOssConfigModel aliOssConfigModel) {
        this.aliOssConfigModel = aliOssConfigModel;
    }

    public AliOssServiceImpl() {
        this.aliOssConfigModel = new AliOssConfigModel();
    }

    @Override
    public BaseResult upload(InputStream inputStream, String fileName) {
        return this.upload(inputStream, null, fileName);
    }

    @Override
    public BaseResult upload(InputStream inputStream, String catalog, String fileName) {
        try {
            String objectKey;
            String fileUrl = String.format("http://%s.%s/%s/", this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getRoot());
            OSS client = new OSSClientBuilder().build(this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getAppKey(), this.aliOssConfigModel.getAppSecret());
            if (!StringUtil.isNullOrEmpty((String)catalog)) {
                fileUrl = fileUrl + catalog + "/" + fileName;
                objectKey = this.aliOssConfigModel.getRoot() + "/" + catalog + "/" + fileName;
            } else {
                fileUrl = fileUrl + fileName;
                objectKey = this.aliOssConfigModel.getRoot() + "/" + fileName;
            }
            client.putObject(this.aliOssConfigModel.getBuckName(), objectKey, inputStream);
            client.shutdown();
            LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            return BaseResult.ok((Object)fileUrl);
        }
        catch (OSSException e) {
            LOGGER.error(S1, (Object)e.getErrorMessage());
            return BaseResult.error((Object)e.getErrorMessage());
        }
        catch (ClientException e) {
            LOGGER.error(S1, (Object)e.getErrorMessage());
            return BaseResult.error((Object)e.getErrorMessage());
        }
    }

    @Override
    public BaseResult uploadBase64(String base64, String fileName) {
        return this.uploadBase64(base64, null, fileName);
    }

    @Override
    public BaseResult uploadBase64(String base64, String catalog, String fileName) {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] bytes = decoder.decode(base64);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return BaseResult.ok((Object)this.upload(inputStream, catalog, fileName));
    }

    @Override
    public BaseResult removeFile(String fileName) {
        return this.removeFiles(Arrays.asList(fileName));
    }

    @Override
    public BaseResult removeFiles(List<String> fileNames) {
        try {
            OSS client = new OSSClientBuilder().build(this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getAppKey(), this.aliOssConfigModel.getAppSecret());
            ArrayList<String> fileObjectNames = new ArrayList<String>();
            String fileUrlPrefix = String.format("http://%s.%s/%s/", this.aliOssConfigModel.getBuckName(), this.aliOssConfigModel.getOssEndPort(), this.aliOssConfigModel.getRoot());
            for (String fileName : fileNames) {
                String fileKey = fileName.replace(fileUrlPrefix, "");
                fileKey = this.aliOssConfigModel.getRoot() + "/" + fileKey;
                fileObjectNames.add(fileKey);
            }
            DeleteObjectsResult deleteObjectsResult = client.deleteObjects(new DeleteObjectsRequest(this.aliOssConfigModel.getBuckName()).withKeys(fileObjectNames));
            deleteObjectsResult.getDeletedObjects();
            client.shutdown();
            LOGGER.info("\u6587\u4ef6\u522a\u9664\u6210\u529f");
            return BaseResult.ok(null);
        }
        catch (OSSException e) {
            LOGGER.error(S1, (Object)e.getErrorMessage());
            return BaseResult.error((Object)e.getErrorMessage());
        }
        catch (ClientException e) {
            LOGGER.error(S1, (Object)e.getErrorMessage());
            return BaseResult.error((Object)e.getErrorMessage());
        }
    }
}

