/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.storage.factory;

import cn.chiship.sdk.third.core.model.DfsDTO;
import cn.chiship.sdk.third.storage.FileStorageService;
import cn.chiship.sdk.third.storage.enums.DfsClassEnum;
import cn.chiship.sdk.third.storage.enums.DfsEnum;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DfsFactory.class);
    private static final Map<Integer, FileStorageService> baseServiceMap = new ConcurrentHashMap<Integer, FileStorageService>();

    public static FileStorageService getFileStorageService(DfsEnum fileStorageEnum) {
        FileStorageService fileStorageService = baseServiceMap.get(fileStorageEnum.getValue());
        if (null == fileStorageService) {
            try {
                Class<?> cls = Class.forName(DfsClassEnum.getValue(fileStorageEnum.getValue()));
                Method staticMethod = cls.getDeclaredMethod("getFileStorageService", new Class[0]);
                fileStorageService = (FileStorageService)staticMethod.invoke(cls, new Object[0]);
                baseServiceMap.put(fileStorageEnum.getValue(), fileStorageService);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        return fileStorageService;
    }

    public static FileStorageService getFileStorageService(DfsEnum fileStorageEnum, DfsDTO dfsDTO) {
        FileStorageService fileStorageService = baseServiceMap.get(fileStorageEnum.getValue());
        if (null == fileStorageService) {
            try {
                Class<?> cls = Class.forName(DfsClassEnum.getValue(fileStorageEnum.getValue()));
                Method staticMethod = cls.getDeclaredMethod("getFileStorageService", DfsDTO.class);
                fileStorageService = (FileStorageService)staticMethod.invoke(cls, dfsDTO);
                baseServiceMap.put(fileStorageEnum.getValue(), fileStorageService);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u6587\u4ef6\u5b58\u50a8\u670d\u52a1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
        return fileStorageService;
    }
}

