/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.other;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.encryption.AesUtil;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.model.EmailConfigModel;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailClient.class);
    private EmailConfigModel emailConfigModel;
    private static EmailClient instance;

    private EmailClient() {
    }

    public static synchronized EmailClient getInstance() {
        if (instance == null) {
            instance = new EmailClient();
        }
        return instance;
    }

    public EmailClient config() {
        try {
            this.emailConfigModel = new EmailConfigModel(PropertiesFileUtil.getInstance((String)"chiship-third").get("EMAIL_CONFIG_HOST"), PropertiesFileUtil.getInstance((String)"chiship-third").get("EMAIL_CONFIG_TRANSPORT_PROTOCOL"), PropertiesFileUtil.getInstance((String)"chiship-third").getBool("EMAIL_CONFIG_SMTP_AUTH"), PropertiesFileUtil.getInstance((String)"chiship-third").get("EMAIL_CONFIG_SMTP_PORT"), PropertiesFileUtil.getInstance((String)"chiship-third").getBool("EMAIL_CONFIG_IS_SSL"), PropertiesFileUtil.getInstance((String)"chiship-third").get("EMAIL_CONFIG_SMTP_SSL_PORT"), PropertiesFileUtil.getInstance((String)"chiship-third").get("EMAIL_CONFIG_SEND_ADDRESS"), PropertiesFileUtil.getInstance((String)"chiship-third").get("EMAIL_CONFIG_SEND_ADDRESS_PASSWORD"));
            if (StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailHost()) || StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailTransportProtocol()) || StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailSmtpAuth().toString()) || StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailSmtpPort()) || StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailIsSsl().toString()) || StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailSmtpSslPort()) || StringUtil.isNullOrEmpty((String)this.emailConfigModel.getMailSendFromAddress()) || StringUtil.isNullOrEmpty((String)AesUtil.aesDecode((String)this.emailConfigModel.getMailSendFromAddressPassword()))) {
                throw new SystemErrorException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u90ae\u7bb1\u7684\u5404\u4e2a\u5c5e\u6027\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
        }
        catch (MissingResourceException e) {
            throw new SystemErrorException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public EmailClient config(EmailConfigModel emailConfigModel) {
        this.emailConfigModel = emailConfigModel;
        this.emailConfigModel.setMailSendFromAddressPassword(AesUtil.aesDecode((String)emailConfigModel.getMailSendFromAddressPassword()));
        return this;
    }

    private Session getSendEmailSession() {
        Properties prop = new Properties();
        prop.setProperty("mail.host", this.emailConfigModel.getMailHost());
        prop.setProperty("mail.transport.protocol", this.emailConfigModel.getMailTransportProtocol());
        prop.setProperty("mail.smtp.auth", String.valueOf(this.emailConfigModel.getMailSmtpAuth()));
        if (Boolean.TRUE.equals(this.emailConfigModel.getMailIsSsl())) {
            prop.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            prop.put("mail.smtp.socketFactory.port", this.emailConfigModel.getMailSmtpSslPort());
            prop.put("mail.smtp.port", this.emailConfigModel.getMailSmtpPort());
            prop.put("mail.smtp.ssl.checkserveridentity", (Object)true);
        } else {
            prop.setProperty("mail.smtp.port", this.emailConfigModel.getMailSmtpPort());
        }
        Session session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EmailClient.this.emailConfigModel.getMailSendFromAddress(), EmailClient.this.emailConfigModel.getMailSendFromAddressPassword());
            }
        });
        session.setDebug(true);
        return session;
    }

    public BaseResult sendText(String toAddress, String subject, String content) {
        try {
            Session session = this.getSendEmailSession();
            Transport ts = session.getTransport();
            ts.connect(this.emailConfigModel.getMailHost(), this.emailConfigModel.getMailSendFromAddress(), this.emailConfigModel.getMailSendFromAddressPassword());
            MimeMessage message = this.createSimpleMail(session, toAddress, subject, content);
            ts.sendMessage((Message)message, message.getAllRecipients());
            ts.close();
            LOGGER.info("--------------------\u53d1\u9001\u90ae\u4ef6\u6210\u529f--------------------------");
            return BaseResult.ok(null);
        }
        catch (Exception e) {
            LOGGER.error("--------------------\u53d1\u9001\u90ae\u4ef6\u9519\u8bef--------------------------");
            LOGGER.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    private MimeMessage createSimpleMail(Session session, String toAddress, String subject, String content) throws Exception {
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(this.emailConfigModel.getMailSendFromAddress()));
        message.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddress));
        message.setSubject(subject);
        message.setContent((Object)content, "text/html;charset=UTF-8");
        return message;
    }

    public static void main(String[] args) {
        System.out.println(AesUtil.aesEncode((String)"BA11C4B21AE2684B"));
        EmailClient emailClient = EmailClient.getInstance().config();
        BaseResult baseResult = emailClient.sendText("alfred@titifootball.com", "2017.11.10\u610f\u89c1\u53cd\u9988\u6536\u96c6", "<p>10\u610f\u89c1\u53cd\u9988\u6536\u96c6</p><span style='color:red'>10\u610f\u89c1\u53cd\u9988\u6536\u96c6</span>");
        System.out.println(baseResult);
    }
}

