/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.dingtalk;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import cn.chiship.sdk.third.dingtalk.DingTalkConstant;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;

public class DingTalkServicesUtils {
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    private BaseConfigModel baseConfigModel;
    private static DingTalkServicesUtils instance;
    private String accessToken = null;

    private DingTalkServicesUtils() {
    }

    public static synchronized DingTalkServicesUtils getInstance() {
        if (instance == null) {
            instance = new DingTalkServicesUtils();
        }
        return instance;
    }

    public DingTalkServicesUtils config() {
        this.baseConfigModel = new BaseConfigModel(this.commonConfigProperties.getValue("third.dingTalk.appKey"), this.commonConfigProperties.getValue("third.dingTalk.appSecret"));
        return this;
    }

    public DingTalkServicesUtils config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }

    public DingTalkServicesUtils token() {
        BaseResult baseResult = this.getToken();
        if (!baseResult.isSuccess()) {
            throw new BusinessException(JSON.toJSONString((Object)baseResult.getData()));
        }
        this.accessToken = baseResult.getData().toString();
        return this;
    }

    public BaseResult getToken() {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("appkey", this.baseConfigModel.getAppKey());
        query.put("appsecret", this.baseConfigModel.getAppSecret());
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"gettoken", DingTalkConstant.commonHeaders(), query);
            baseResult = DingTalkConstant.analysisHttpResponse(baseResult);
            if (baseResult.isSuccess()) {
                JSONObject jsonObject = (JSONObject)baseResult.getData();
                return BaseResult.ok((Object)jsonObject.getString("access_token"));
            }
            return baseResult;
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult getDepartmentList() {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", this.getAccessToken());
        query.put("fetch_child", String.valueOf(Boolean.TRUE));
        query.put("id", String.valueOf(1));
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"department/list", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult getUserList(Long departmentId) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", this.getAccessToken());
        query.put("department_id", String.valueOf(departmentId));
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"user/simplelist", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult getUserListByPage(Long departmentId, Integer page) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", this.getAccessToken());
        query.put("department_id", String.valueOf(departmentId));
        query.put("offset", String.valueOf((page - 1) * 50));
        query.put("size", String.valueOf(50));
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"user/listbypage", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult getRoleList() {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", this.getAccessToken());
        query.put("offset", String.valueOf(0));
        query.put("size", String.valueOf(50));
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"topapi/role/list", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult getRoleUserList(Long roleId) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put("access_token", this.getAccessToken());
        query.put("role_id", String.valueOf(roleId));
        query.put("offset", String.valueOf(0));
        query.put("size", String.valueOf(50));
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"topapi/role/simplelist", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult getReportList(String templateName, Integer day, String userId) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        if (null == templateName) {
            templateName = "\u65e5\u62a5";
        }
        if (null == day) {
            day = 1;
        }
        query.put("access_token", this.getAccessToken());
        query.put("start_time", String.valueOf(System.currentTimeMillis() - (long)(day * 24 * 60 * 60 * 1000)));
        query.put("end_time", String.valueOf(System.currentTimeMillis()));
        query.put("template_name", templateName);
        if (null != userId) {
            query.put("userid", userId);
        }
        query.put("cursor", String.valueOf(0));
        query.put("size", String.valueOf(50));
        try {
            BaseResult baseResult = HttpUtils.doGet((String)"https://oapi.dingtalk.com/", (String)"topapi/report/list", DingTalkConstant.commonHeaders(), query);
            return DingTalkConstant.analysisHttpResponse(baseResult);
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public String getAccessToken() {
        if (StringUtil.isNullOrEmpty((String)this.accessToken)) {
            throw new BusinessException("token\u4e3a\u7a7a\uff01\u8bf7\u94fe\u5f0f\u8c03\u7528\u5982\u4e0b\u65b9\u6cd5\uff1aDingTalkServicesUtils.getInstance().config().token()\u83b7\u5f97Token");
        }
        return this.accessToken;
    }
}

