/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.core.util.RedisUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.baidu.BaiDuAiConstant;
import cn.chiship.sdk.third.baidu.BaiDuAiResultAnalyze;
import cn.chiship.sdk.third.core.model.baidu.BaiDuOcrConfigModel;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaiDuOcrUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaiDuOcrUtils.class);
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    public static final String IMAGE_JPEG_BASE64 = "data:image/jpeg;base64,";
    public static final String IMAGE_PNG_BASE64 = "data:image/png;base64,";
    public static final String STRING_URL = "url";
    public static final String STRING_IMAGE = "image";
    private static final String ACCESS_TOKEN = "access_token";
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuOcrUtils instance;
    private String accessToken = null;

    private BaiDuOcrUtils() {
    }

    public static synchronized BaiDuOcrUtils getInstance() {
        if (instance == null) {
            instance = new BaiDuOcrUtils();
        }
        return instance;
    }

    public BaiDuOcrUtils config() {
        this.baiDuOcrConfigModel = new BaiDuOcrConfigModel(this.commonConfigProperties.getValue("third.ai.baidu.apiKey"), this.commonConfigProperties.getValue("third.ai.baidu.secretKey"), this.commonConfigProperties.getValue("third.ai.baidu.appId"));
        return this;
    }

    public BaiDuOcrUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel = baiDuOcrConfigModel;
        return this;
    }

    public BaiDuOcrUtils token() {
        BaseResult baseResult = this.getToken();
        if (!baseResult.isSuccess()) {
            throw new BusinessException(JSON.toJSONString((Object)baseResult.getData()));
        }
        this.accessToken = baseResult.getData().toString();
        return this;
    }

    public BaseResult getToken() {
        String key = "THIRD:BAI_DU_AIP_ACCESS_TOKEN:" + this.baiDuOcrConfigModel.getAppKey();
        String token = RedisUtil.get((String)key);
        if (!StringUtil.isNullOrEmpty((String)token)) {
            return BaseResult.ok((Object)token);
        }
        HashMap<String, String> query = new HashMap<String, String>(7);
        query.put("grant_type", "client_credentials");
        query.put("client_id", this.baiDuOcrConfigModel.getAppKey());
        query.put("client_secret", this.baiDuOcrConfigModel.getAppSecret());
        try {
            BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/oauth/2.0/token", BaiDuAiConstant.commonHeaders(), query, new HashMap(2));
            baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
            if (!baseResult.isSuccess()) {
                return baseResult;
            }
            JSONObject dataJson = (JSONObject)baseResult.getData();
            String accessToken = dataJson.getString(ACCESS_TOKEN);
            int expiresIn = dataJson.getInteger("expires_in");
            baseResult.setData((Object)accessToken);
            RedisUtil.set((String)key, (String)accessToken, (int)expiresIn);
            return baseResult;
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult idCardOcr(String image, Boolean isFront, Boolean isNetwork) {
        String idCardSide = Boolean.TRUE.equals(isFront) ? "front" : "back";
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(2);
        if (Boolean.TRUE.equals(isNetwork)) {
            body.put(STRING_URL, image);
        } else {
            body.put(STRING_IMAGE, this.replaceImage(image));
        }
        body.put("id_card_side", idCardSide);
        body.put("detect_direction", "true");
        body.put("detect_risk", "false");
        BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/rest/2.0/ocr/v1/idcard", BaiDuAiConstant.commonHeaders(), query, body);
        baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
        return BaiDuAiResultAnalyze.analyzeIdCard(baseResult);
    }

    public BaseResult bankCard(String image, Boolean isNetwork) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(2);
        if (Boolean.TRUE.equals(isNetwork)) {
            body.put(STRING_URL, image);
        } else {
            body.put(STRING_IMAGE, this.replaceImage(image));
        }
        BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/rest/2.0/ocr/v1/bankcard", BaiDuAiConstant.commonHeaders(), query, body);
        baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
        return BaiDuAiResultAnalyze.analyzeBankCard(baseResult);
    }

    public BaseResult businessLicense(String image, Boolean isNetwork) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(2);
        if (Boolean.TRUE.equals(isNetwork)) {
            body.put(STRING_URL, image);
        } else {
            body.put(STRING_IMAGE, this.replaceImage(image));
        }
        BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/rest/2.0/ocr/v1/business_license", BaiDuAiConstant.commonHeaders(), query, body);
        baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
        return BaiDuAiResultAnalyze.analyzeBusinessLicense(baseResult);
    }

    public BaseResult passport(String image, Boolean isNetwork) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(2);
        if (Boolean.TRUE.equals(isNetwork)) {
            body.put(STRING_URL, image);
        } else {
            body.put(STRING_IMAGE, this.replaceImage(image));
        }
        BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/rest/2.0/ocr/v1/passport", BaiDuAiConstant.commonHeaders(), query, body);
        baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
        return BaiDuAiResultAnalyze.analyzePassport(baseResult);
    }

    public BaseResult socialSecurityCard(String image, Boolean isNetwork) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(2);
        if (Boolean.TRUE.equals(isNetwork)) {
            body.put(STRING_URL, image);
        } else {
            body.put(STRING_IMAGE, this.replaceImage(image));
        }
        BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/rest/2.0/ocr/v1/social_security_card", BaiDuAiConstant.commonHeaders(), query, body);
        baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
        return BaiDuAiResultAnalyze.analyzeSocialSecurityCard(baseResult);
    }

    public BaseResult licensePlate(String image, Boolean isNetwork) {
        HashMap<String, String> query = new HashMap<String, String>(2);
        query.put(ACCESS_TOKEN, this.getAccessToken());
        HashMap<String, String> body = new HashMap<String, String>(2);
        if (Boolean.TRUE.equals(isNetwork)) {
            body.put(STRING_URL, image);
        } else {
            body.put(STRING_IMAGE, this.replaceImage(image));
        }
        BaseResult baseResult = HttpUtils.doPost((String)"https://aip.baidubce.com", (String)"/rest/2.0/ocr/v1/license_plate", BaiDuAiConstant.commonHeaders(), query, body);
        baseResult = BaiDuAiConstant.analysisAipHttpResponse(baseResult);
        return BaiDuAiResultAnalyze.analyzeLicensePlate(baseResult);
    }

    private String replaceImage(String image) {
        return image.replace(IMAGE_PNG_BASE64, "").replace(IMAGE_JPEG_BASE64, "");
    }

    public String getAccessToken() {
        if (StringUtil.isNullOrEmpty((String)this.accessToken)) {
            throw new BusinessException("token\u4e3a\u7a7a\uff01\u8bf7\u94fe\u5f0f\u8c03\u7528\u5982\u4e0b\u65b9\u6cd5\uff1aDingTalkServicesUtils.getInstance().config().token()\u83b7\u5f97Token");
        }
        return this.accessToken;
    }
}

