/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.third.baidu.BaiDuAiConstant;
import cn.chiship.sdk.third.baidu.singleton.AipFaceClientSingleton;
import cn.chiship.sdk.third.core.model.baidu.BaiDuOcrConfigModel;
import com.alibaba.fastjson.JSON;
import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.FaceVerifyRequest;
import com.baidu.aip.face.MatchRequest;
import java.util.ArrayList;
import org.json.JSONObject;

public class BaiDuFaceUtils {
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuFaceUtils instance;

    private BaiDuFaceUtils() {
    }

    public static synchronized BaiDuFaceUtils getInstance() {
        if (instance == null) {
            instance = new BaiDuFaceUtils();
        }
        return instance;
    }

    public BaiDuFaceUtils config() {
        this.baiDuOcrConfigModel = new BaiDuOcrConfigModel(this.commonConfigProperties.getValue("third.ai.baidu.apiKey"), this.commonConfigProperties.getValue("third.ai.baidu.secretKey"), this.commonConfigProperties.getValue("third.ai.baidu.appId"));
        return this;
    }

    public BaiDuFaceUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel = baiDuOcrConfigModel;
        return this;
    }

    public BaseResult faceMatch(String image1, Boolean isNetwork1, String image2, Boolean isNetwork2) {
        try {
            AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
            image1 = Boolean.TRUE.equals(isNetwork1) ? ImageUtil.getImgBase64ByUrl((String)image1) : ImageUtil.getImgStrByFile((String)image1);
            image2 = Boolean.TRUE.equals(isNetwork2) ? ImageUtil.getImgBase64ByUrl((String)image2) : ImageUtil.getImgStrByFile((String)image2);
            MatchRequest req1 = new MatchRequest(image1, "BASE64");
            MatchRequest req2 = new MatchRequest(image2, "BASE64");
            ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
            requests.add(req1);
            requests.add(req2);
            JSONObject res = client.match(requests);
            BaseResult baseResult = BaiDuAiConstant.analysisJson(res);
            if (baseResult.isSuccess()) {
                com.alibaba.fastjson.JSONObject data = JSON.parseObject((String)baseResult.getData().toString());
                baseResult.setData((Object)data.getJSONObject("result").getString("score"));
            }
            return baseResult;
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }

    public BaseResult faceVerify(String image, Boolean isNetwork) {
        AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
        try {
            image = Boolean.TRUE.equals(isNetwork) ? ImageUtil.getImgBase64ByUrl((String)image) : ImageUtil.getImgStrByFile((String)image);
            FaceVerifyRequest req = new FaceVerifyRequest(image, "BASE64");
            ArrayList<FaceVerifyRequest> list = new ArrayList<FaceVerifyRequest>();
            list.add(req);
            JSONObject res = client.faceverify(list);
            BaseResult baseResult = BaiDuAiConstant.analysisJson(res);
            if (baseResult.isSuccess()) {
                com.alibaba.fastjson.JSONObject data = JSON.parseObject((String)baseResult.getData().toString());
                baseResult.setData((Object)data.getJSONObject("result").getString("face_liveness"));
            }
            return baseResult;
        }
        catch (Exception e) {
            return ExceptionUtil.formatException((Exception)e);
        }
    }
}

