/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.third.baidu.model.BankCardVo;
import cn.chiship.sdk.third.baidu.model.BusinessLicenseVo;
import cn.chiship.sdk.third.baidu.model.IdCardVo;
import cn.chiship.sdk.third.baidu.model.LicensePlateVo;
import cn.chiship.sdk.third.baidu.model.PassportVo;
import cn.chiship.sdk.third.baidu.model.SocialSecurityCardVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;

public class BaiDuAiResultAnalyze {
    private static final String WORDS = "words";
    private static final String WORDS_RESULT = "words_result";

    private BaiDuAiResultAnalyze() {
    }

    public static BaseResult analyzeIdCard(BaseResult baseResult) {
        if (baseResult.isSuccess()) {
            JSONObject json = (JSONObject)baseResult.getData();
            JSONObject wordsResult = BaiDuAiResultAnalyze.recombinationJSON(json.getJSONObject(WORDS_RESULT));
            IdCardVo idCardVo = (IdCardVo)JSON.parseObject((String)wordsResult.toString(), IdCardVo.class);
            return BaseResult.ok((Object)idCardVo);
        }
        return baseResult;
    }

    public static BaseResult analyzeBankCard(BaseResult baseResult) {
        if (baseResult.isSuccess()) {
            JSONObject json = (JSONObject)baseResult.getData();
            JSONObject result = json.getJSONObject("result");
            BankCardVo bankCardVo = (BankCardVo)JSON.parseObject((String)result.toString(), BankCardVo.class);
            return BaseResult.ok((Object)bankCardVo);
        }
        return baseResult;
    }

    public static BaseResult analyzeBusinessLicense(BaseResult baseResult) {
        if (baseResult.isSuccess()) {
            JSONObject json = (JSONObject)baseResult.getData();
            JSONObject wordsResult = BaiDuAiResultAnalyze.recombinationJSON(json.getJSONObject(WORDS_RESULT));
            BusinessLicenseVo businessLicenseVo = (BusinessLicenseVo)JSON.parseObject((String)wordsResult.toString(), BusinessLicenseVo.class);
            return BaseResult.ok((Object)businessLicenseVo);
        }
        return baseResult;
    }

    public static BaseResult analyzePassport(BaseResult baseResult) {
        if (baseResult.isSuccess()) {
            JSONObject json = (JSONObject)baseResult.getData();
            JSONObject wordsResult = BaiDuAiResultAnalyze.recombinationJSON(json.getJSONObject(WORDS_RESULT));
            PassportVo passportVo = (PassportVo)JSON.parseObject((String)wordsResult.toString(), PassportVo.class);
            return BaseResult.ok((Object)passportVo);
        }
        return baseResult;
    }

    public static BaseResult analyzeSocialSecurityCard(BaseResult baseResult) {
        if (baseResult.isSuccess()) {
            JSONObject json = (JSONObject)baseResult.getData();
            JSONObject wordsResult = BaiDuAiResultAnalyze.recombinationJSON(json.getJSONObject(WORDS_RESULT));
            SocialSecurityCardVo socialSecurityCardVo = (SocialSecurityCardVo)JSON.parseObject((String)wordsResult.toString(), SocialSecurityCardVo.class);
            return BaseResult.ok((Object)socialSecurityCardVo);
        }
        return baseResult;
    }

    public static BaseResult analyzeLicensePlate(BaseResult baseResult) {
        if (baseResult.isSuccess()) {
            JSONObject json = (JSONObject)baseResult.getData();
            JSONObject wordsResult = json.getJSONObject(WORDS_RESULT);
            LicensePlateVo licensePlateVo = (LicensePlateVo)JSON.parseObject((String)wordsResult.toString(), LicensePlateVo.class);
            return BaseResult.ok((Object)licensePlateVo);
        }
        return baseResult;
    }

    private static JSONObject recombinationJSON(JSONObject wordsResult) {
        JSONObject json = new JSONObject();
        Set keys = wordsResult.keySet();
        for (String key : keys) {
            json.put(key, (Object)wordsResult.getJSONObject(key).getString(WORDS));
        }
        return json;
    }
}

