/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class BaiDuAiConstant
extends ThirdConstants {
    private static final String ERROR_CODE = "error_code";
    public static final String AIP_SERVER_HOST = "https://aip.baidubce.com";
    public static final String GET_TOKEN = "/oauth/2.0/token";
    public static final String ID_CARD = "/rest/2.0/ocr/v1/idcard";
    public static final String BANK_CARD = "/rest/2.0/ocr/v1/bankcard";
    public static final String BUSINESS_LICENSE = "/rest/2.0/ocr/v1/business_license";
    public static final String PASS_PORT = "/rest/2.0/ocr/v1/passport";
    public static final String SOCIAL_SECURITY_CARD = "/rest/2.0/ocr/v1/social_security_card";
    public static final String LICENSE_PLATE = "/rest/2.0/ocr/v1/license_plate";

    public static Map<String, String> commonHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(2);
        return headers;
    }

    public static String getCodeStatusMessage(Integer code) {
        HashMap<String, String> codeStatus = new HashMap<String, String>(2);
        codeStatus.put("SDK102", "\u8bfb\u53d6\u56fe\u7247\u6587\u4ef6\u9519\u8bef");
        codeStatus.put("0", "\u64cd\u4f5c\u6210\u529f");
        codeStatus.put("6", "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u7528\u6237\u6570\u636e\uff0c\u521b\u5efa\u5e94\u7528\u65f6\u672a\u52fe\u9009\u76f8\u5173\u63a5\u53e3");
        codeStatus.put("216015", "\u6a21\u5757\u5173\u95ed");
        codeStatus.put("216100", "\u975e\u6cd5\u53c2\u6570");
        codeStatus.put("216101", "\u53c2\u6570\u6570\u91cf\u4e0d\u591f");
        codeStatus.put("216102", "\u4e1a\u52a1\u4e0d\u652f\u6301");
        codeStatus.put("216103", "\u53c2\u6570\u592a\u957f");
        codeStatus.put("216110", "APP ID\u4e0d\u5b58\u5728");
        codeStatus.put("216111", "\u975e\u6cd5\u7528\u6237ID");
        codeStatus.put("216200", "\u7a7a\u7684\u56fe\u7247");
        codeStatus.put("216201", "\u56fe\u7247\u683c\u5f0f\u9519\u8bef");
        codeStatus.put("216202", "\u56fe\u7247\u5927\u5c0f\u9519\u8bef");
        codeStatus.put("216300", "DB\u9519\u8bef");
        codeStatus.put("216400", "\u540e\u7aef\u7cfb\u7edf\u9519\u8bef");
        codeStatus.put("216401", "\u5185\u90e8\u9519\u8bef");
        codeStatus.put("216500", "\u672a\u77e5\u9519\u8bef");
        codeStatus.put("216600", "\u8eab\u4efd\u8bc1\u7684ID\u683c\u5f0f\u9519\u8bef");
        codeStatus.put("216601", "\u8eab\u4efd\u8bc1\u7684ID\u548c\u540d\u5b57\u4e0d\u5339\u914d");
        codeStatus.put("216630", "\u8bc6\u522b\u9519\u8bef");
        codeStatus.put("216631", "\u8bc6\u522b\u94f6\u884c\u5361\u9519\u8bef\uff08\u901a\u5e38\u4e3a\u68c0\u6d4b\u4e0d\u5230\u94f6\u884c\u5361\uff09");
        codeStatus.put("216632", "unknown error");
        codeStatus.put("216633", "\u8bc6\u522b\u8eab\u4efd\u8bc1\u9519\u8bef\uff08\u901a\u5e38\u4e3a\u68c0\u6d4b\u4e0d\u5230\u8eab\u4efd\u8bc1\uff09");
        codeStatus.put("216634", "\u68c0\u6d4b\u9519\u8bef");
        codeStatus.put("216635", "\u83b7\u53d6mask\u56fe\u7247\u9519\u8bef");
        codeStatus.put("222202", "\u56fe\u7247\u4e2d\u6ca1\u6709\u4eba\u8138");
        codeStatus.put("222203", "\u65e0\u6cd5\u89e3\u6790\u4eba\u8138");
        codeStatus.put("282000", "\u4e1a\u52a1\u903b\u8f91\u5c42\u5185\u90e8\u9519\u8bef");
        codeStatus.put("282001", "\u4e1a\u52a1\u903b\u8f91\u5c42\u540e\u7aef\u670d\u52a1\u9519\u8bef");
        codeStatus.put("282100", "\u56fe\u7247\u538b\u7f29\u8f6c\u7801\u9519\u8bef");
        codeStatus.put("282102", "\u672a\u68c0\u6d4b\u5230\u56fe\u7247\u4e2d\u8bc6\u522b\u76ee\u6807\uff0c\u8bf7\u786e\u4fdd\u56fe\u7247\u4e2d\u5305\u542b\u5bf9\u5e94\u5361\u8bc1\u7968\u636e\uff0c\u51fa\u73b0\u6b64\u95ee\u9898\u7684\u539f\u56e0\u4e00\u822c\u4e3a\uff1a\u60a8\u4e0a\u4f20\u4e86\u975e\u5361\u8bc1\u56fe\u7247\u3001\u56fe\u7247\u4e0d\u5b8c\u6574\u6216\u6a21\u7cca");
        codeStatus.put("282103", "\u56fe\u7247\u76ee\u6807\u8bc6\u522b\u9519\u8bef\uff0c\u8bf7\u786e\u4fdd\u56fe\u7247\u4e2d\u5305\u542b\u5bf9\u5e94\u5361\u8bc1\u7968\u636e\uff0c\u51fa\u73b0\u6b64\u95ee\u9898\u7684\u539f\u56e0\u4e00\u822c\u4e3a\uff1a\u60a8\u4e0a\u4f20\u4e86\u975e\u5361\u8bc1\u56fe\u7247\u3001\u56fe\u7247\u4e0d\u5b8c\u6574\u6216\u6a21\u7cca");
        return (String)codeStatus.get(code.toString());
    }

    public static BaseResult analysisAipHttpResponse(BaseResult baseResult) {
        if (!baseResult.isSuccess()) {
            return baseResult;
        }
        com.alibaba.fastjson.JSONObject json = JSON.parseObject((String)StringUtil.getString((Object)baseResult.getData()));
        if (json.containsKey((Object)ERROR_CODE)) {
            String msg = BaiDuAiConstant.getCodeStatusMessage(json.getInteger(ERROR_CODE));
            return BaseResult.error((Object)(msg == null ? "\u9519\u8bef\u7801:\u3010" + json.getInteger(ERROR_CODE) + "\u3011,\u63cf\u8ff0\uff1a\u3010" + json.getString("error_msg") + "\u3011" : msg));
        }
        return BaseResult.ok((Object)json);
    }

    public static BaseResult analysisJson(JSONObject json) {
        Boolean success = false;
        String msg = null;
        if (json.has(ERROR_CODE)) {
            Integer errorCode = json.getInt(ERROR_CODE);
            if (0 == errorCode) {
                success = true;
            }
            if (StringUtil.isNullOrEmpty((String)(msg = BaiDuAiConstant.getCodeStatusMessage(json.getInt(ERROR_CODE))))) {
                msg = "\u9519\u8bef\u7801:\u3010" + errorCode + "\u3011,\u63cf\u8ff0\uff1a\u3010" + json.getString("error_msg") + "\u3011";
            }
        } else {
            success = true;
        }
        if (Boolean.TRUE.equals(success)) {
            return BaseResult.ok((Object)json);
        }
        return BaseResult.error(msg);
    }
}

