/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.ali;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import com.aliyun.dm20151123.Client;
import com.aliyun.dm20151123.models.SingleSendMailRequest;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliMailUtil {
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(AliMailUtil.class);
    private BaseConfigModel baseConfigModel;
    private static AliMailUtil instance;

    private AliMailUtil() {
    }

    public static synchronized AliMailUtil getInstance() {
        if (instance == null) {
            instance = new AliMailUtil();
        }
        return instance;
    }

    public AliMailUtil config() {
        try {
            this.baseConfigModel = new BaseConfigModel(this.commonConfigProperties.getValue("third.sms.ali.accessKey"), this.commonConfigProperties.getValue("third.sms.ali.accessSecret"));
            if (StringUtil.isNullOrEmpty((String)this.baseConfigModel.getAppKey()) || StringUtil.isNullOrEmpty((String)this.baseConfigModel.getAppSecret())) {
                throw new SystemErrorException("\u5144\u5f1f,\u8bf7\u786e\u4fdd\u963f\u91cc\u4e91\u77ed\u4fe1\u7684\u5404\u4e2a\u5c5e\u6027[ALI_SMS_ACCESS_KEY_ID\u3001ALI_SMS_ACCESS_KEY_SECRET]\u914d\u7f6e\u5b58\u5728\u6216\u503c\u4e0d\u4e3a\u7a7a!");
            }
        }
        catch (MissingResourceException e) {
            throw new SystemErrorException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public AliMailUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }

    public BaseResult sendEmail() {
        try {
            Config config = new Config().setAccessKeyId(this.baseConfigModel.getAppKey()).setAccessKeySecret(this.config().baseConfigModel.getAppSecret());
            config.endpoint = "dm.aliyuncs.com";
            Client client = new Client(config);
            SingleSendMailRequest singleSendMailRequest = new SingleSendMailRequest().setAccountName("system@email.chiship.cn").setAddressType(Integer.valueOf(1)).setToAddress("li1991-hello@163.com").setSubject("\u6d4b\u8bd5").setHtmlBody("<h2>111</h2>").setReplyToAddress(Boolean.valueOf(true));
            RuntimeOptions runtime = new RuntimeOptions();
            client.singleSendMailWithOptions(singleSendMailRequest, runtime);
            return BaseResult.ok(null);
        }
        catch (TeaException error) {
            Common.assertAsString((Object)error.message);
            return BaseResult.error((Object)error.message);
        }
        catch (Exception e) {
            TeaException error = new TeaException(e.getMessage(), (Throwable)e);
            Common.assertAsString((Object)error.message);
            LOGGER.error("AliMailUtil\u53d1\u751f\u9519\u8bef:{}", (Object)e.getLocalizedMessage());
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }
}

