/*
 * Decompiled with CFR 0.152.
 */
package cn.chiship.sdk.third.ali;

import cn.chiship.sdk.core.base.BaseResult;
import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.properties.CommonConfigProperties;
import cn.chiship.sdk.third.core.model.BaseConfigModel;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliDySmsUtil {
    CommonConfigProperties commonConfigProperties = CommonConfigProperties.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(AliDySmsUtil.class);
    static final String PRODUCT = "Dysmsapi";
    static final String DOMAIN = "dysmsapi.aliyuncs.com";
    private String aliDySmsSignName;
    private String aliDySmsTemplateCode;
    private BaseConfigModel baseConfigModel;
    private static AliDySmsUtil instance;

    private AliDySmsUtil() {
    }

    public static synchronized AliDySmsUtil getInstance() {
        if (instance == null) {
            instance = new AliDySmsUtil();
        }
        return instance;
    }

    public AliDySmsUtil config() {
        try {
            this.baseConfigModel = new BaseConfigModel(this.commonConfigProperties.getValue("third.sms.ali.accessKey"), this.commonConfigProperties.getValue("third.sms.ali.accessSecret"));
        }
        catch (MissingResourceException e) {
            throw new SystemErrorException("\u5144\u5f1f,\u8bf7\u786e\u4fdd'chiship-third'\u6587\u4ef6\u5b58\u5728!");
        }
        return this;
    }

    public AliDySmsUtil config(BaseConfigModel baseConfigModel) {
        this.baseConfigModel = baseConfigModel;
        return this;
    }

    public AliDySmsUtil load(String signName, String templateCode) {
        this.aliDySmsSignName = signName;
        this.aliDySmsTemplateCode = templateCode;
        return this;
    }

    public BaseResult sendSms(String mobile, Map<String, String> paramsMap) {
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.baseConfigModel.getAppKey(), (String)this.baseConfigModel.getAppSecret());
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setPhoneNumbers(mobile);
            request.setSignName(this.aliDySmsSignName);
            request.setTemplateCode(this.aliDySmsTemplateCode);
            if (null != paramsMap) {
                request.setTemplateParam(JSON.toJSONString(paramsMap));
            }
            SendSmsResponse response = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
            LOGGER.info("\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e----------------");
            LOGGER.info("Code={}", (Object)response.getCode());
            LOGGER.info("Message={}", (Object)response.getMessage());
            LOGGER.info("RequestId={}", (Object)response.getRequestId());
            LOGGER.info("BizId={}", (Object)response.getBizId());
            if (response.getCode() != null && "OK".equals(response.getCode())) {
                QuerySendDetailsResponse querySendDetailsResponse = this.querySendDetails(mobile, response.getBizId());
                LOGGER.info("\u77ed\u4fe1\u660e\u7ec6\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u6570\u636e----------------");
                LOGGER.info("Code={}", (Object)querySendDetailsResponse.getCode());
                LOGGER.info("Message={}", (Object)querySendDetailsResponse.getMessage());
                return BaseResult.ok(null);
            }
            return BaseResult.error((Object)response.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("SmsUtil\u53d1\u751f\u9519\u8bef:{}", (Object)e.getLocalizedMessage());
            return BaseResult.error((Object)ExceptionUtil.formatException((Exception)e));
        }
    }

    public QuerySendDetailsResponse querySendDetails(String mobile, String bizId) {
        try {
            System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
            System.setProperty("sun.net.client.defaultReadTimeout", "10000");
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.baseConfigModel.getAppKey(), (String)this.baseConfigModel.getAppSecret());
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)PRODUCT, (String)DOMAIN);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            QuerySendDetailsRequest request = new QuerySendDetailsRequest();
            request.setPhoneNumber(mobile);
            request.setBizId(bizId);
            SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
            request.setSendDate(ft.format(new Date()));
            request.setPageSize(Long.valueOf(10L));
            request.setCurrentPage(Long.valueOf(1L));
            return (QuerySendDetailsResponse)acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (Exception e) {
            LOGGER.error("SmsUtil\u53d1\u751f\u9519\u8bef:", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        AliDySmsUtil aliDySmsUtil = AliDySmsUtil.getInstance().config().load("\u667a\u8230\u5de5\u4f5c\u5ba4", "SMS_147418172");
        HashMap<String, String> paramsMap = new HashMap<String, String>(2);
        paramsMap.put("code", "123421");
        aliDySmsUtil.sendSms("18363003321", paramsMap);
    }
}

