package cn.chiship.sdk.third.wechat.network;


import cn.chiship.sdk.core.exception.ExceptionUtil;

import cn.chiship.sdk.core.exception.custom.BusinessException;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.RedisUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.core.util.http.HttpUtils;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.wechat.core.common.MiniProgramVersion;
import cn.chiship.sdk.third.wechat.core.common.WxPubCommonConstants;
import cn.chiship.sdk.third.wechat.core.common.WeChatCommonResult;
import cn.chiship.sdk.third.wechat.core.common.WxMiniProgramCommonConstants;
import cn.chiship.sdk.third.wechat.core.config.WeiXinConfig;
import cn.chiship.sdk.third.wechat.core.entity.subscribe.Template;
import cn.chiship.sdk.third.wechat.core.util.WxBizDataCrypt;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

/**
 * @author lijian
 */
public class WeiXinMiniProgramServicesUtil {

    private static final String ACCESS_TOKEN = "access_token";


    private WeiXinConfig weiXinConfig;
    private static WeiXinMiniProgramServicesUtil instance;

    private String accessToken = null;

    private WeiXinMiniProgramServicesUtil() {
    }

    public static WeiXinMiniProgramServicesUtil getInstance() {
        if (instance == null) {
            synchronized (WeiXinMiniProgramServicesUtil.class) {
                if (instance == null) {
                    instance = new WeiXinMiniProgramServicesUtil();
                }
            }
        }
        return instance;
    }

    public WeiXinMiniProgramServicesUtil config() {
        try {
            this.weiXinConfig = new WeiXinConfig(
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("WEI_XIN_MINI_APP_KEY"),
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("WEI_XIN_MINI_APP_SECRET")
            );
            if (StringUtil.isNullOrEmpty(weiXinConfig.getAppKey()) ||
                    StringUtil.isNullOrEmpty(weiXinConfig.getAppSecret())) {
                throw new SystemErrorException("兄弟,请确保微信小程序的各个属性[WEI_XIN_MINI_APP_KEY、WEI_XIN_MINI_APP_SECRET]配置存在或值不为空!");
            }
        } catch (MissingResourceException e) {
            throw new SystemErrorException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public WeiXinMiniProgramServicesUtil config(WeiXinConfig weiXinConfig) {
        this.weiXinConfig = weiXinConfig;
        return this;
    }

    public WeiXinMiniProgramServicesUtil token() {
        WeChatCommonResult weChatCommonResult = getToken();
        if (!weChatCommonResult.isSuccess()) {
            throw new BusinessException(JSON.toJSONString(weChatCommonResult.getData()));
        }
        this.accessToken = weChatCommonResult.getData().toString();
        return this;
    }


    public WeChatCommonResult getToken() {
        String key = ThirdConstants.REDIS_WEIXIN_MINI_PROGRAM_ACCESS_TOKEN + ":" + this.weiXinConfig.getAppKey();
        String token = RedisUtil.get(key);
        if (!StringUtil.isNullOrEmpty(token)) {
            return WeChatCommonResult.ok(token);
        }
        Map<String, String> query = new HashMap<>(7);
        query.put("grant_type", "client_credential");
        query.put("appid", this.weiXinConfig.getAppKey());
        query.put("secret", this.weiXinConfig.getAppSecret());
        try {
            String responseResult = HttpUtils.doGet(
                    WxMiniProgramCommonConstants.API_WEI_XIN_SERVER_HOST,
                    WxMiniProgramCommonConstants.GET_TOKEN,
                    WxMiniProgramCommonConstants.commonHeaders(),
                    query
            );
            WeChatCommonResult result = WxMiniProgramCommonConstants.analysisPubHttpResponse(responseResult);
            if (!result.isSuccess()) {
                return result;
            }
            JSONObject dataJson = (JSONObject) result.getData();
            String accessToken = dataJson.getString("access_token");
            String expiresIn = dataJson.getString("expires_in");
            result.setData(accessToken);
            RedisUtil.set(key, accessToken, Integer.valueOf(expiresIn));
            return result;
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 获取小程序码，适用于需要的码数量极多的业务场景。通过该接口生成的小程序码，永久有效，数量暂无限制
     *
     * @param page
     * @param scene
     * @param miniProgramVersion
     * @return
     */
    private WeChatCommonResult getQrCode1(String page, String scene, MiniProgramVersion miniProgramVersion) {
        Map<String, String> query = new HashMap<>(7);
        query.put(ACCESS_TOKEN, getAccessToken());
        Map<String, String> body = new HashMap<>(7);
        body.put("scene", scene);
        body.put("page", page);
        body.put("env_version", miniProgramVersion.getVersion());

        try {
            String responseTicketResult = HttpUtils.doPost(
                    WxMiniProgramCommonConstants.API_WEI_XIN_SERVER_HOST,
                    WxMiniProgramCommonConstants.GET_QRCODE1,
                    WxMiniProgramCommonConstants.commonHeaders(),
                    query,
                    JSON.toJSONString(body)
            );

            System.out.println(responseTicketResult);

            return WeChatCommonResult.ok(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }



    /**
     * 通过code换取网页授权access_token
     *
     * @param code 登录时code
     * @return 结果
     */
    public WeChatCommonResult code2Session(String code) {

        Map<String, String> query = new HashMap<>(7);
        query.put("grant_type", "authorization_code");
        query.put("appid", weiXinConfig.getAppKey());
        query.put("secret", weiXinConfig.getAppSecret());
        query.put("js_code", code);

        try {
            String responseResult = HttpUtils.doGet(
                    WxMiniProgramCommonConstants.API_WEI_XIN_SERVER_HOST,
                    WxMiniProgramCommonConstants.JSOCODE2SESSION,
                    WxPubCommonConstants.commonHeaders(), query);
            return WxMiniProgramCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 解密开放数据
     *
     * @param encryptedData 包括敏感数据在内的完整用户信息的加密数据
     * @param iv            加密初始向量
     * @param sessionKey    登陆换取的sessionKey
     * @return 结果
     */
    public WeChatCommonResult decryptingOpenData(String encryptedData, String iv, String sessionKey) {
        WxBizDataCrypt wxBizDataCrypt = new WxBizDataCrypt(encryptedData, sessionKey, iv);
        return wxBizDataCrypt.decryptData();
    }

    /**
     * 订阅消息发送
     * 待整理
     *
     * @return 结果
     */
    public WeChatCommonResult messageSubscribeSend(Template template) {
        Map<String, String> query = new HashMap<>(2);
        //getToken();
        WeChatCommonResult weChatCommonResult = null;
        if (!weChatCommonResult.isSuccess()) {
            return weChatCommonResult;
        }
        String token = weChatCommonResult.getData().toString();
        query.put("access_token", token);
        try {
            String body = template.toJSON();
            String responseResult = HttpUtils.doPost(
                    WxPubCommonConstants.API_WEI_XIN_SERVER_HOST,
                    WxPubCommonConstants.MESSAGE_SUBSCRIBE_SEND,
                    WxPubCommonConstants.commonHeaders(),
                    query,
                    body);
            return WxPubCommonConstants.analysisPubHttpResponse(responseResult);
        } catch (Exception e) {
            return WeChatCommonResult.error(ExceptionUtil.formatException(e));
        }
    }

    public String getAccessToken() {
        if (StringUtil.isNullOrEmpty(accessToken)) {
            throw new BusinessException("token为空！请链式调用如下方法：WeiXinMiniProgramServicesUtil.getInstance().config().token()获得Token");
        }
        return accessToken;
    }


    public static void main(String[] args) {
        WeiXinMiniProgramServicesUtil weiXinMiniProgramServicesUtil = WeiXinMiniProgramServicesUtil.getInstance().config().token();
        weiXinMiniProgramServicesUtil.getQrCode1("/pages/my/message/index","123123213",MiniProgramVersion.MINI_PROGRAM_TRIAL);
    }
}
