package cn.chiship.sdk.third.wechat.core.util;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;


/**
 * XML 解析工具
 * @author lj
 *
 */
@SuppressWarnings("all")
public class XMLUtil {
	/**
	 * @param strxml
	 * @return 结果
	 * @throws DocumentException 
	 * @throws IOException 
	 */
	public static SortedMap<String, Object> doXMLParse(String strxml) throws DocumentException, IOException {
		strxml = strxml.replaceFirst("encoding=\".*\"", "encoding=\"UTF-8\"");
		if (null == strxml || "".equals(strxml)) {
			return null;
		}
		SortedMap<String, Object> map = new TreeMap<String, Object>();
		InputStream in = new ByteArrayInputStream(strxml.getBytes("UTF-8"));
		SAXReader reader=new SAXReader();
		Document document=reader.read(in);
		Element root=document.getRootElement();
		List<Element>elements=root.elements();
		for (Element element : elements) {
			map.put(element.getName(), element.getText().trim());
		}
		// 关闭流
		in.close();
		return map;
	}
}
