package cn.chiship.sdk.third.wechat.core.util;

import cn.chiship.sdk.third.wechat.core.common.WxPubCommonConstants;
import cn.chiship.sdk.third.wechat.core.entity.pub.*;
import cn.chiship.sdk.third.wechat.core.entity.pub.message.*;
import com.alibaba.fastjson.JSON;
import com.thoughtworks.xstream.XStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lijian
 */
public class PubMessageToXml {
    private static final Integer TEN = 10;
    private static final Integer ELEVEN = 11;

    private PubMessageToXml() {
    }

    /**
     * 将微信XML格式数据转换成Map集合
     *
     * @param ins
     * @return 结果
     * @throws IOException
     * @throws DocumentException
     */
    public static Map<String, String> xmlToMap(InputStream ins) throws IOException, DocumentException {
        Map<String, String> map = new HashMap<>(2);
        SAXReader reader = new SAXReader();
        Document document = reader.read(ins);
        Element root = document.getRootElement();
        List<Element> elements = root.elements();
        for (Element element : elements) {
            map.put(element.getName(), element.getText().trim());
        }
        ins.close();
        return map;
    }

    /**
     * 将文本消息组装成微信识别的XML
     *
     * @param textMessage 文本消息实体类
     * @return 结果
     */
    public static String textMessageToXML(TextMessage textMessage) {
        XStream xStream = new XStream();
        xStream.alias("xml", textMessage.getClass());
        return xStream.toXML(textMessage);
    }

    /**
     * 将图片消息组装成微信识别的XML
     *
     * @param imageMessage 图片消息实体类
     * @return 结果
     */
    public static String imageMessageToXML(ImageMessage imageMessage) {
        XStream xStream = new XStream();
        xStream.alias("xml", imageMessage.getClass());
        return xStream.toXML(imageMessage);
    }

    /**
     * 将图文消息组装成微信识别的XML
     *
     * @param imageTextMessage 图文消息实体类
     * @param item             图文消息项目实体类
     * @return 结果
     */
    public static String imageTextMessageToXML(ImageTextMessage imageTextMessage, Item item) {
        XStream xStream = new XStream();
        xStream.alias("xml", imageTextMessage.getClass());
        xStream.alias("item", item.getClass());
        return xStream.toXML(imageTextMessage);
    }


    /**
     * 加载文本消息
     *
     * @param fromUserName 接收者
     * @param toUserName   发送者
     * @param content      文本消息内容
     * @return 结果
     */
    public static String initTextMessage(String fromUserName, String toUserName, String content) {
        TextMessage textMessage = new TextMessage();
        textMessage.setFromUserName(toUserName);
        textMessage.setToUserName(fromUserName);
        textMessage.setContent(content);
        textMessage.setMsgType(WxPubCommonConstants.MESSAGE_TEXT);
        textMessage.setCreateTime(System.currentTimeMillis());
        return textMessageToXML(textMessage);
    }

    /**
     * 加载图片消息
     *
     * @param fromUserName 接收者
     * @param toUserName   发送者
     * @param mediaId      图片ID
     * @return 结果
     */
    public static String initImageMessage(String fromUserName, String toUserName, String mediaId) {
        ImageMessage imageMessage = new ImageMessage();
        imageMessage.setFromUserName(toUserName);
        imageMessage.setToUserName(fromUserName);
        imageMessage.setCreateTime(System.currentTimeMillis());
        imageMessage.setMsgType(WxPubCommonConstants.MESSAGE_IMAGE);
        Image image = new Image();
        image.setMediaId(mediaId);
        imageMessage.setImage(image);
        return imageMessageToXML(imageMessage);
    }

    /**
     * 加载图文列表信息
     *
     * @param fromUserName 接收者
     * @param toUserName   发送者
     * @param item         项
     * @param count        条数
     * @return 结果
     */
    public static String initImageTextMessage(String fromUserName, String toUserName, List<Item> item, Integer count) {
        ImageTextMessage imageTextMessage = new ImageTextMessage();
        imageTextMessage.setFromUserName(toUserName);
        imageTextMessage.setToUserName(fromUserName);
        imageTextMessage.setCreateTime(System.currentTimeMillis());
        imageTextMessage.setArticleCount(count);
        imageTextMessage.setMsgType(WxPubCommonConstants.MESSAGE_NEWS);
        if (count < ELEVEN) {
            imageTextMessage.setArticles(item);
            return imageTextMessageToXML(imageTextMessage, new Item());
        } else {
            List<Item> item_1 = new ArrayList<>();
            for (int i = 0; i < TEN; i++) {
                item_1.add(item.get(i));
            }
            imageTextMessage.setArticles(item_1);
            return imageTextMessageToXML(imageTextMessage, new Item());
        }
    }

    /**
     * 封装客服发送图文消息
     */
    public static String initImageText(String openId, List<ImageTextNewsArticles> articles) {
        ImageTextNews imageTextNews = new ImageTextNews();
        imageTextNews.setArticles(articles);
        ImageText imageText = new ImageText();
        imageText.setTouser(openId);
        imageText.setMsgtype("news");
        imageText.setNews(imageTextNews);
        return JSON.toJSONString(imageText);
    }

    /**
     * 封装客服发送文字消息
     *
     * @return 结果
     */
    public static String initText(String openId, String content) {
        Text text = new Text();
        text.setContent(content);
        TextNews textNews = new TextNews();
        textNews.setTouser(openId);
        textNews.setMsgtype("text");
        textNews.setText(text);
        return JSON.toJSONString(textNews);
    }

}
