package cn.chiship.sdk.third.core.common;

/**
 * restful接口结果常量枚举类
 *
 * @author lijian
 */
public enum ThirdResultConstants {
    /**
     * 阿里云短信系列异常
     */
    ERROR_ALI_DY_SMS(506001, "阿里云短信异常"),

    /**
     * 阿里云存储系列异常
     */
    ERROR_ALI_OSS(506002, "阿里云存储异常"),

    /**
     * 百度AI系列异常
     */
    ERROR_BAIDU_AI(506003, "百度AI异常"),

    /**
     * 钉钉系列异常
     */
    ERROR_DING_TALK(506007, "钉钉异常");

    /**
     * 自定义状态码
     */
    private int code;

    /**
     * 状态信息
     */
    private String message;

    ThirdResultConstants(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return code;
    }


    public String getMessage() {
        return message;
    }


}
