package cn.chiship.sdk.third.baidu;

import cn.chiship.sdk.core.exception.ExceptionUtil;
import cn.chiship.sdk.core.exception.custom.SystemErrorException;
import cn.chiship.sdk.core.util.ImageUtil;
import cn.chiship.sdk.core.util.PropertiesFileUtil;
import cn.chiship.sdk.core.util.StringUtil;
import cn.chiship.sdk.third.baidu.singleton.AipFaceClientSingleton;
import cn.chiship.sdk.third.core.common.ThirdConstants;
import cn.chiship.sdk.third.core.common.ThirdResult;
import cn.chiship.sdk.third.core.model.BaiDuOcrConfigModel;
import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.FaceVerifyRequest;
import com.baidu.aip.face.MatchRequest;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.MissingResourceException;

/**
 * @author lijian
 */
public class BaiDuFaceUtils {
    private BaiDuOcrConfigModel baiDuOcrConfigModel;
    private static BaiDuFaceUtils instance;

    private BaiDuFaceUtils() {
    }

    public static BaiDuFaceUtils getInstance() {
        if (instance == null) {
            synchronized (BaiDuFaceUtils.class) {
                if (instance == null) {
                    instance = new BaiDuFaceUtils();
                }
            }
        }
        return instance;
    }

    public BaiDuFaceUtils config() {
        try {
            this.baiDuOcrConfigModel = new BaiDuOcrConfigModel(
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("BAI_DU_AI_API_KEY"),
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("BAI_DU_AI_SECRET_KEY"),
                    PropertiesFileUtil.getInstance(ThirdConstants.PROPERTIES_FILE_NAME).get("BAI_DU_AI_APP_ID")
            );
            if (StringUtil.isNullOrEmpty(this.baiDuOcrConfigModel.getAppId()) ||
                    StringUtil.isNullOrEmpty(this.baiDuOcrConfigModel.getAppSecret()) ||
                    StringUtil.isNullOrEmpty(this.baiDuOcrConfigModel.getAppId())) {
                throw new SystemErrorException("兄弟,请确保百度AI的各个属性配置存在或值不为空!");
            }
        } catch (MissingResourceException e) {
            throw new SystemErrorException(ThirdConstants.ERROR_EXIST_TIP_1);
        }
        return this;
    }

    public BaiDuFaceUtils config(BaiDuOcrConfigModel baiDuOcrConfigModel) {
        this.baiDuOcrConfigModel = baiDuOcrConfigModel;
        return this;
    }


    /**
     * 人脸对比
     *
     * @param image1
     * @param isNetwork1
     * @param image2
     * @param isNetwork2
     * @return 结果
     */
    public ThirdResult faceMatch(String image1, Boolean isNetwork1, String image2, Boolean isNetwork2) {

        try {
            AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();
            if (Boolean.TRUE.equals(isNetwork1)) {
                image1 = ImageUtil.getImgBase64ByUrl(image1);
            } else {
                image1 = ImageUtil.getImgStrByFile(image1);
            }
            if (Boolean.TRUE.equals(isNetwork2)) {
                image2 = ImageUtil.getImgBase64ByUrl(image2);
            } else {
                image2 = ImageUtil.getImgStrByFile(image2);
            }
            MatchRequest req1 = new MatchRequest(image1, "BASE64");
            MatchRequest req2 = new MatchRequest(image2, "BASE64");
            ArrayList<MatchRequest> requests = new ArrayList<>();
            requests.add(req1);
            requests.add(req2);
            JSONObject res = client.match(requests);
            ThirdResult thirdResult = BaiDuAiConstant.analysisJson(res);
            if (thirdResult.isSuccess()) {

                com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSON.parseObject(thirdResult.getData().toString());
                thirdResult.setData(data.getJSONObject("result").getString("score"));
            }
            return thirdResult;
        } catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }

    /**
     * 在线活体检测
     *
     * @param image
     * @param isNetwork
     * @return 结果
     */
    public ThirdResult faceVerify(String image, Boolean isNetwork) {
        AipFace client = AipFaceClientSingleton.getInstance(this.baiDuOcrConfigModel).getAipOcr();

        try {
            if (Boolean.TRUE.equals(isNetwork)) {
                image = ImageUtil.getImgBase64ByUrl(image);
            } else {
                image = ImageUtil.getImgStrByFile(image);
            }
            FaceVerifyRequest req = new FaceVerifyRequest(image, "BASE64");
            ArrayList<FaceVerifyRequest> list = new ArrayList<>();
            list.add(req);
            JSONObject res = client.faceverify(list);
            ThirdResult thirdResult = BaiDuAiConstant.analysisJson(res);
            if (thirdResult.isSuccess()) {
                com.alibaba.fastjson.JSONObject data = com.alibaba.fastjson.JSON.parseObject(thirdResult.getData().toString());
                thirdResult.setData(data.getJSONObject("result").getString("face_liveness"));
            }
            return thirdResult;
        } catch (Exception e) {
            return ThirdResult.error(ExceptionUtil.formatException(e));
        }
    }
}





