package cn.chiship.sdk.third.baidu;


import cn.chiship.sdk.third.baidu.model.*;
import cn.chiship.sdk.third.core.common.ThirdResult;
import com.alibaba.fastjson.JSON;
import org.json.JSONObject;

import java.util.Set;

/**
 * 结果分析
 *
 * @author lijian
 */
public class BaiDuAiResultAnalyze {
    private static final String WORDS = "words";
    private static final String WORDS_RESULT = "words_result";

    private BaiDuAiResultAnalyze() {
    }

    /**
     * 解析身份证
     *
     * @param thirdResult 解析内容
     * @return 结果
     */
    public static ThirdResult analyzeIdCard(ThirdResult thirdResult) {
        if (thirdResult.isSuccess()) {
            JSONObject json = (JSONObject) thirdResult.getData();
            JSONObject wordsResult = recombinationJSON(json.getJSONObject(WORDS_RESULT));
            IdCardVo idCardVo = JSON.parseObject(wordsResult.toString(), IdCardVo.class);
            return ThirdResult.ok(idCardVo);
        } else {
            return thirdResult;
        }
    }

    /**
     * 解析银行卡
     *
     * @param thirdResult 解析内容
     * @return 结果
     */
    public static ThirdResult analyzeBankCard(ThirdResult thirdResult) {
        if (thirdResult.isSuccess()) {
            JSONObject json = (JSONObject) thirdResult.getData();
            JSONObject result = json.getJSONObject("result");
            BankCardVo bankCardVo = JSON.parseObject(result.toString(), BankCardVo.class);
            return ThirdResult.ok(bankCardVo);
        } else {
            return thirdResult;
        }
    }

    /**
     * 解析营业执照
     *
     * @param thirdResult
     * @return 结果
     */
    public static ThirdResult analyzeBusinessLicense(ThirdResult thirdResult) {
        if (thirdResult.isSuccess()) {
            JSONObject json = (JSONObject) thirdResult.getData();
            JSONObject wordsResult = recombinationJSON(json.getJSONObject(WORDS_RESULT));
            BusinessLicenseVo businessLicenseVo = JSON.parseObject(wordsResult.toString(), BusinessLicenseVo.class);
            return ThirdResult.ok(businessLicenseVo);
        } else {
            return thirdResult;
        }
    }

    /**
     * 解析护照
     *
     * @param thirdResult
     * @return 结果
     */
    public static ThirdResult analyzePassport(ThirdResult thirdResult) {
        if (thirdResult.isSuccess()) {
            JSONObject json = (JSONObject) thirdResult.getData();
            JSONObject wordsResult = recombinationJSON(json.getJSONObject(WORDS_RESULT));
            PassportVo passportVo = JSON.parseObject(wordsResult.toString(), PassportVo.class);
            return ThirdResult.ok(passportVo);
        } else {
            return thirdResult;
        }

    }

    /**
     * 解析社保卡
     *
     * @param thirdResult
     * @return 结果
     */
    public static ThirdResult analyzeSocialSecurityCard(ThirdResult thirdResult) {
        if (thirdResult.isSuccess()) {
            JSONObject json = (JSONObject) thirdResult.getData();
            JSONObject wordsResult = recombinationJSON(json.getJSONObject(WORDS_RESULT));
            SocialSecurityCardVo socialSecurityCardVo = JSON.parseObject(wordsResult.toString(), SocialSecurityCardVo.class);
            return ThirdResult.ok(socialSecurityCardVo);
        } else {
            return thirdResult;
        }

    }

    /**
     * 解析社保卡
     *
     * @param thirdResult
     * @return 结果
     */
    public static ThirdResult analyzeLicensePlate(ThirdResult thirdResult) {
        if (thirdResult.isSuccess()) {
            JSONObject json = (JSONObject) thirdResult.getData();
            JSONObject wordsResult = json.getJSONObject(WORDS_RESULT);
            LicensePlateVo licensePlateVo = JSON.parseObject(wordsResult.toString(), LicensePlateVo.class);
            return ThirdResult.ok(licensePlateVo);
        } else {
            return thirdResult;
        }

    }


    /**
     * 重组WorldResult
     *
     * @param wordsResult json
     * @return 结果
     */
    private static JSONObject recombinationJSON(JSONObject wordsResult) {
        JSONObject json = new JSONObject();
        Set<String> keys = wordsResult.keySet();
        for (String key : keys) {
            json.put(key, wordsResult.getJSONObject(key).getString(WORDS));
        }
        return json;
    }
}
