package cn.chiship.sdk.third.wechat.core.util;


import cn.chiship.sdk.core.util.Sha1Util;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

/**
 * @author lijian
 */
public class WeChatPubUtil {
    private WeChatPubUtil() {
    }

    /**
     * 微信公众号验签
     *
     * @param token
     * @param signature
     * @param timestamp
     * @param nonce
     * @return 结果
     * @throws NoSuchAlgorithmException
     */
    public static boolean checkSignature(String token, String signature, String timestamp,
                                         String nonce) throws NoSuchAlgorithmException {
        String[] arrs = new String[]{token, timestamp, nonce};
        Arrays.sort(arrs);
        StringBuilder builder = new StringBuilder();
        for (String string : arrs) {
            builder.append(string);
        }
        String temp = Sha1Util.sha1Encode(builder.toString());
        return temp.equals(signature);
    }
}
